/*
 * Decompiled with CFR 0.152.
 */
package org.encog.cloud;

import java.util.HashMap;
import org.encog.cloud.CloudRequest;
import org.encog.cloud.CloudTask;
import org.encog.cloud.EncogCloudError;

public class EncogCloud {
    public static final String DEFAULT_SERVER = "http://cloud.encog.com/";
    private String session;
    private String server;

    public EncogCloud() {
        this(DEFAULT_SERVER);
    }

    public EncogCloud(String server) {
        this.server = server;
        if (!this.server.endsWith("/")) {
            this.server = this.server + '/';
        }
    }

    public CloudTask beginTask(String name) {
        CloudTask result = new CloudTask(this);
        result.init(name);
        return result;
    }

    public void connect(String uid, String pwd) {
        CloudRequest request = new CloudRequest();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("uid", uid);
        args.put("pwd", pwd);
        request.performURLPOST(false, this.constructService("login"), args);
        if (!"success".equals(request.getStatus())) {
            throw new EncogCloudError(request.getMessage());
        }
        this.session = request.getSession();
    }

    public String constructService(String service) {
        return this.server + service;
    }

    public String getSession() {
        return this.session;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void logout() {
        CloudRequest request = new CloudRequest();
        request.performURLGET(false, this.session + "logout");
        this.session = null;
    }

    public void validateSession(boolean failOnError) {
        int max = failOnError ? 1 : 5;
        for (int i = 0; i < max; ++i) {
            CloudRequest request = new CloudRequest();
            request.performURLGET(false, this.session);
            if (!"success".equals(request.getStatus())) continue;
            return;
        }
        if (failOnError) {
            throw new EncogCloudError("Connection lost");
        }
    }
}

