/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.encog.engine.EncogEngineError;
import org.encog.engine.concurrency.EngineTask;
import org.encog.engine.concurrency.PoolItem;
import org.encog.engine.concurrency.TaskGroup;

public class EngineConcurrency {
    private static EngineConcurrency instance;
    private Throwable threadError;
    private int currentTaskGroup;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public static EngineConcurrency getInstance() {
        if (instance == null) {
            instance = new EngineConcurrency();
        }
        return instance;
    }

    public void checkError() {
        if (this.threadError != null) {
            throw new EncogEngineError(this.threadError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskGroup createTaskGroup() {
        TaskGroup result = null;
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            ++this.currentTaskGroup;
            result = new TaskGroup(this.currentTaskGroup);
        }
        return result;
    }

    public void processTask(EngineTask task) {
        this.processTask(task, null);
    }

    public void processTask(EngineTask task, TaskGroup group) {
        if (this.executor == null) {
            task.run();
        } else {
            if (this.threadError != null) {
                Throwable t = this.threadError;
                this.threadError = null;
                throw new EncogEngineError(t);
            }
            PoolItem item = new PoolItem(task, group);
            if (group != null) {
                group.taskStarting();
            }
            this.executor.execute(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerError(Throwable t) {
        EngineConcurrency engineConcurrency = this;
        synchronized (engineConcurrency) {
            this.threadError = t;
        }
    }

    public void shutdown(long timeout) {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(timeout, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (InterruptedException e) {
                throw new EncogEngineError(e);
            }
        }
    }
}

