/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency.calc;

import org.encog.engine.concurrency.calc.CalculationResult;
import org.encog.engine.concurrency.calc.ConcurrentCalculate;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.kernels.KernelNetworkCalc;

public class CalcOpenCLDevice {
    private final EncogCLDevice device;
    private final ConcurrentCalculate calc;
    private final KernelNetworkCalc kernelCalc;
    private boolean busy;

    public CalcOpenCLDevice(EncogCLDevice device, ConcurrentCalculate calc) {
        this.device = device;
        this.calc = calc;
        this.kernelCalc = new KernelNetworkCalc(this.device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalculationResult calculateError() {
        if (this.busy) {
            return new CalculationResult(false, false);
        }
        try {
            this.busy = true;
            CalculationResult result = new CalculationResult(true, true);
            this.kernelCalc.calculate(0, (int)this.calc.getTrainingData().getRecordCount());
            result.setError(this.kernelCalc.getError());
            CalculationResult calculationResult = result;
            return calculationResult;
        }
        finally {
            this.busy = false;
        }
    }

    public ConcurrentCalculate getCalc() {
        return this.calc;
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public void setNetwork(FlatNetwork network) {
        this.kernelCalc.setFlat(network);
    }

    public void setTraining(EngineIndexableSet training) {
        this.kernelCalc.setTraining(training);
    }
}

