/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency.calc;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.EncogEngine;
import org.encog.engine.concurrency.calc.CalcOpenCLDevice;
import org.encog.engine.concurrency.calc.CalculationResult;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.opencl.EncogCLDevice;

public final class ConcurrentCalculate {
    private static ConcurrentCalculate instance;
    private FlatNetwork network;
    private EngineIndexableSet trainingData;
    private final List<CalcOpenCLDevice> devices = new ArrayList<CalcOpenCLDevice>();
    private boolean useOpenCL;

    public static ConcurrentCalculate getInstance() {
        if (instance == null) {
            instance = new ConcurrentCalculate();
        }
        return instance;
    }

    private ConcurrentCalculate() {
    }

    public double calculateError() {
        if (this.useOpenCL) {
            for (CalcOpenCLDevice dev : this.devices) {
                CalculationResult result = dev.calculateError();
                if (!result.isExecuted()) continue;
                return result.getError();
            }
        }
        return this.network.calculateError(this.trainingData);
    }

    public FlatNetwork getNetwork() {
        return this.network;
    }

    public EngineIndexableSet getTrainingData() {
        return this.trainingData;
    }

    public void initCL() {
        this.devices.clear();
        for (EncogCLDevice device : EncogEngine.getInstance().getCL().getEnabledDevices()) {
            CalcOpenCLDevice d = new CalcOpenCLDevice(device, this);
            this.devices.add(d);
            if (this.network != null) {
                d.setNetwork(this.network);
            }
            if (this.trainingData == null) continue;
            d.setTraining(this.trainingData);
        }
        this.useOpenCL = true;
    }

    public boolean isUseOpenCL() {
        return this.useOpenCL;
    }

    public void setNetwork(FlatNetwork network) {
        this.network = network;
        for (CalcOpenCLDevice dev : this.devices) {
            dev.setTraining(this.trainingData);
        }
    }

    public void setTrainingData(EngineIndexableSet trainingData) {
        this.trainingData = trainingData;
        for (CalcOpenCLDevice dev : this.devices) {
            dev.setTraining(trainingData);
        }
    }

    public void setUseOpenCL(boolean useOpenCL) {
        this.useOpenCL = useOpenCL;
    }
}

