/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.concurrency.job;

import org.encog.engine.StatusReportable;
import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.concurrency.TaskGroup;
import org.encog.engine.concurrency.job.JobUnitContext;
import org.encog.engine.concurrency.job.JobUnitWorker;

public abstract class ConcurrentJob {
    private final StatusReportable report;
    private int totalTasks;
    private int current;
    private boolean shouldStop = false;

    public ConcurrentJob(StatusReportable report) {
        this.report = report;
        this.current = 1;
    }

    public abstract int loadWorkload();

    public abstract void performJobUnit(JobUnitContext var1);

    public void process() {
        Object task;
        this.totalTasks = this.loadWorkload();
        int currentTask = 0;
        TaskGroup group = EngineConcurrency.getInstance().createTaskGroup();
        while ((task = this.requestNextTask()) != null && !this.shouldStop) {
            JobUnitContext context = new JobUnitContext();
            context.setJobUnit(task);
            context.setOwner(this);
            context.setTaskNumber(++currentTask);
            JobUnitWorker worker = new JobUnitWorker(context);
            EngineConcurrency.getInstance().processTask(worker, group);
        }
        group.waitForComplete();
        EngineConcurrency.getInstance().checkError();
    }

    public void reportStatus(JobUnitContext context, String status) {
        this.report.report(this.totalTasks, this.current++, status);
    }

    public abstract Object requestNextTask();

    public boolean getShouldStop() {
        return this.shouldStop;
    }

    public void stop() {
        this.shouldStop = true;
    }
}

