/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.EncogEngineError;
import org.encog.engine.network.activation.ActivationFunction;

public class ActivationCompetitive
implements ActivationFunction {
    public static final int PARAM_COMPETITIVE_MAX_WINNERS = 0;
    private static final long serialVersionUID = 5396927873082336888L;
    private final double[] params = new double[1];

    public ActivationCompetitive() {
        this(1);
    }

    public ActivationCompetitive(int winners) {
        this.params[0] = winners;
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        boolean[] winners = new boolean[x.length];
        double sumWinners = 0.0;
        int i = 0;
        while ((double)i < this.params[0]) {
            double maxFound = Double.NEGATIVE_INFINITY;
            int winner = -1;
            for (int j = start; j < start + size; ++j) {
                if (winners[j] || !(x[j] > maxFound)) continue;
                winner = j;
                maxFound = x[j];
            }
            sumWinners += maxFound;
            winners[winner] = true;
            ++i;
        }
        for (i = start; i < start + size; ++i) {
            x[i] = winners[i] ? x[i] / sumWinners : 0.0;
        }
    }

    @Override
    public ActivationFunction clone() {
        return new ActivationCompetitive((int)this.params[0]);
    }

    @Override
    public double derivativeFunction(double d) {
        throw new EncogEngineError("Can't use the competitive activation function where a derivative is required.");
    }

    public int getMaxWinners() {
        return (int)this.params[0];
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{"maxWinners"};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public boolean hasDerivative() {
        return false;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

