/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.activation;

import org.encog.engine.network.activation.ActivationFunction;

public class ActivationRamp
implements ActivationFunction {
    public static final int PARAM_RAMP_HIGH_THRESHOLD = 0;
    public static final int PARAM_RAMP_LOW_THRESHOLD = 1;
    public static final int PARAM_RAMP_HIGH = 2;
    public static final int PARAM_RAMP_LOW = 3;
    private static final long serialVersionUID = 6336245112244386279L;
    private double[] params = new double[4];

    public ActivationRamp(double thresholdHigh, double thresholdLow, double high, double low) {
        this.params[0] = thresholdHigh;
        this.params[1] = thresholdLow;
        this.params[2] = high;
        this.params[3] = low;
    }

    public ActivationRamp() {
        this(1.0, 0.0, 1.0, 0.0);
    }

    @Override
    public ActivationFunction clone() {
        return new ActivationRamp(this.params[0], this.params[1], this.params[2], this.params[3]);
    }

    public double getHigh() {
        return this.params[2];
    }

    public double getLow() {
        return this.params[3];
    }

    public double getThresholdHigh() {
        return this.params[0];
    }

    public double getThresholdLow() {
        return this.params[1];
    }

    @Override
    public boolean hasDerivative() {
        return true;
    }

    public void setThresholdLow(double d) {
        this.setParam(1, d);
    }

    public void setThresholdHigh(double d) {
        this.setParam(0, d);
    }

    public void setLow(double d) {
        this.setParam(3, d);
    }

    public void setHigh(double d) {
        this.setParam(2, d);
    }

    @Override
    public void activationFunction(double[] x, int start, int size) {
        double slope = (this.params[0] - this.params[1]) / (this.params[2] - this.params[3]);
        for (int i = start; i < start + size; ++i) {
            x[i] = x[i] < this.params[1] ? this.params[3] : (x[i] > this.params[0] ? this.params[2] : slope * x[i]);
        }
    }

    @Override
    public double derivativeFunction(double d) {
        return 1.0;
    }

    @Override
    public String[] getParamNames() {
        String[] result = new String[]{"thresholdHigh", "thresholdLow", "high", "low"};
        return result;
    }

    @Override
    public double[] getParams() {
        return this.params;
    }

    @Override
    public void setParam(int index, double value) {
        this.params[index] = value;
    }

    @Override
    public String getOpenCLExpression(boolean derivative) {
        return null;
    }
}

