/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import java.io.Serializable;
import java.util.ArrayList;
import org.encog.engine.EncogEngineError;
import org.encog.engine.EngineNeuralNetwork;
import org.encog.engine.data.BasicEngineData;
import org.encog.engine.data.EngineData;
import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.engine.network.flat.FlatLayer;
import org.encog.engine.util.EngineArray;
import org.encog.engine.util.ErrorCalculation;

public class FlatNetwork
implements EngineNeuralNetwork,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_BIAS_ACTIVATION = 1.0;
    public static final double NO_BIAS_ACTIVATION = 0.0;
    private int inputCount;
    private int[] layerCounts;
    private int[] layerContextCount;
    private int[] layerFeedCounts;
    private int[] layerIndex;
    private double[] layerOutput;
    private int outputCount;
    private int[] weightIndex;
    private double[] weights;
    private ActivationFunction[] activationFunctions;
    private int[] contextTargetOffset;
    private int[] contextTargetSize;
    private double[] biasActivation;
    private int beginTraining;
    private int endTraining;
    private boolean isLimited;
    private double connectionLimit;

    public FlatNetwork() {
    }

    public FlatNetwork(FlatLayer[] layers) {
        this.init(layers);
    }

    public FlatNetwork(int input, int hidden1, int hidden2, int output, boolean tanh) {
        FlatLayer[] layers;
        double[] params = new double[1];
        ActivationFunction act = tanh ? new ActivationTANH() : new ActivationSigmoid();
        params[0] = 1.0;
        if (hidden1 == 0 && hidden2 == 0) {
            layers = new FlatLayer[]{new FlatLayer(act, input, 1.0, params), new FlatLayer(act, output, 0.0, params)};
        } else if (hidden1 == 0 || hidden2 == 0) {
            int count = Math.max(hidden1, hidden2);
            layers = new FlatLayer[]{new FlatLayer(act, input, 1.0, params), new FlatLayer(act, count, 1.0, params), new FlatLayer(act, output, 0.0, params)};
        } else {
            layers = new FlatLayer[]{new FlatLayer(act, input, 1.0, params), new FlatLayer(act, hidden1, 1.0, params), new FlatLayer(act, hidden2, 1.0, params), new FlatLayer(act, output, 0.0, params)};
        }
        this.isLimited = false;
        this.connectionLimit = 0.0;
        this.init(layers);
    }

    public double calculateError(EngineIndexableSet data) {
        ErrorCalculation errorCalculation = new ErrorCalculation();
        double[] actual = new double[this.outputCount];
        EngineData pair = BasicEngineData.createPair(data.getInputSize(), data.getIdealSize());
        int i = 0;
        while ((long)i < data.getRecordCount()) {
            data.getRecord(i, pair);
            this.compute(pair.getInputArray(), actual);
            errorCalculation.updateError(actual, pair.getIdealArray());
            ++i;
        }
        return errorCalculation.calculate();
    }

    public void clearContext() {
        int index = 0;
        for (int i = 0; i < this.layerIndex.length; ++i) {
            int j;
            boolean hasBias = this.layerContextCount[i] + this.layerFeedCounts[i] != this.layerCounts[i];
            for (j = 0; j < this.layerFeedCounts[i]; ++j) {
                this.layerOutput[index++] = 0.0;
            }
            if (hasBias) {
                this.layerOutput[index++] = this.biasActivation[i];
            }
            for (j = 0; j < this.layerContextCount[i]; ++j) {
                this.layerOutput[index++] = 0.0;
            }
        }
    }

    public FlatNetwork clone() {
        FlatNetwork result = new FlatNetwork();
        this.cloneFlatNetwork(result);
        return result;
    }

    public void cloneFlatNetwork(FlatNetwork result) {
        result.inputCount = this.inputCount;
        result.layerCounts = EngineArray.arrayCopy(this.layerCounts);
        result.layerIndex = EngineArray.arrayCopy(this.layerIndex);
        result.layerOutput = EngineArray.arrayCopy(this.layerOutput);
        result.layerFeedCounts = EngineArray.arrayCopy(this.layerFeedCounts);
        result.contextTargetOffset = EngineArray.arrayCopy(this.contextTargetOffset);
        result.contextTargetSize = EngineArray.arrayCopy(this.contextTargetSize);
        result.layerContextCount = EngineArray.arrayCopy(this.layerContextCount);
        result.biasActivation = EngineArray.arrayCopy(this.biasActivation);
        result.outputCount = this.outputCount;
        result.weightIndex = this.weightIndex;
        result.weights = this.weights;
        result.activationFunctions = new ActivationFunction[this.activationFunctions.length];
        for (int i = 0; i < result.activationFunctions.length; ++i) {
            result.activationFunctions[i] = this.activationFunctions[i].clone();
        }
        result.beginTraining = this.beginTraining;
        result.endTraining = this.endTraining;
    }

    @Override
    public void compute(double[] input, double[] output) {
        int sourceIndex = this.layerOutput.length - this.layerCounts[this.layerCounts.length - 1];
        EngineArray.arrayCopy(input, 0, this.layerOutput, sourceIndex, this.inputCount);
        for (int i = this.layerIndex.length - 1; i > 0; --i) {
            this.computeLayer(i);
        }
        EngineArray.arrayCopy(this.layerOutput, 0, output, 0, this.outputCount);
    }

    protected void computeLayer(int currentLayer) {
        int inputIndex = this.layerIndex[currentLayer];
        int outputIndex = this.layerIndex[currentLayer - 1];
        int inputSize = this.layerCounts[currentLayer];
        int outputSize = this.layerFeedCounts[currentLayer - 1];
        int index = this.weightIndex[currentLayer - 1];
        int limitX = outputIndex + outputSize;
        int limitY = inputIndex + inputSize;
        for (int x = outputIndex; x < limitX; ++x) {
            double sum = 0.0;
            for (int y = inputIndex; y < limitY; ++y) {
                sum += this.weights[index++] * this.layerOutput[y];
            }
            this.layerOutput[x] = sum;
        }
        this.activationFunctions[currentLayer - 1].activationFunction(this.layerOutput, outputIndex, outputSize);
        int offset = this.contextTargetOffset[currentLayer];
        for (int x = 0; x < this.contextTargetSize[currentLayer]; ++x) {
            this.layerOutput[offset + x] = this.layerOutput[outputIndex + x];
        }
    }

    @Override
    public void decodeNetwork(double[] data) {
        if (data.length != this.weights.length) {
            throw new EncogEngineError("Incompatable weight sizes, can't assign length=" + data.length + " to length=" + data.length);
        }
        this.weights = data;
    }

    @Override
    public double[] encodeNetwork() {
        return this.weights;
    }

    public int[] getContextTargetOffset() {
        return this.contextTargetOffset;
    }

    public int[] getContextTargetSize() {
        return this.contextTargetSize;
    }

    @Override
    public int getEncodeLength() {
        return this.weights.length;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    public int[] getLayerCounts() {
        return this.layerCounts;
    }

    public int[] getLayerFeedCounts() {
        return this.layerFeedCounts;
    }

    public int[] getLayerIndex() {
        return this.layerIndex;
    }

    public double[] getLayerOutput() {
        return this.layerOutput;
    }

    public int getNeuronCount() {
        int result = 0;
        for (int element : this.layerCounts) {
            result += element;
        }
        return result;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    public int[] getWeightIndex() {
        return this.weightIndex;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public Class<?> hasSameActivationFunction() {
        ArrayList map = new ArrayList();
        for (ActivationFunction activation : this.activationFunctions) {
            if (map.contains(activation.getClass())) continue;
            map.add(activation.getClass());
        }
        if (map.size() != 1) {
            return null;
        }
        return (Class)map.get(0);
    }

    public void init(FlatLayer[] layers) {
        int layerCount = layers.length;
        this.inputCount = layers[0].getCount();
        this.outputCount = layers[layerCount - 1].getCount();
        this.layerCounts = new int[layerCount];
        this.layerContextCount = new int[layerCount];
        this.weightIndex = new int[layerCount];
        this.layerIndex = new int[layerCount];
        this.activationFunctions = new ActivationFunction[layerCount];
        this.layerFeedCounts = new int[layerCount];
        this.contextTargetOffset = new int[layerCount];
        this.contextTargetSize = new int[layerCount];
        this.biasActivation = new double[layerCount];
        int index = 0;
        int neuronCount = 0;
        int weightCount = 0;
        for (int i = layers.length - 1; i >= 0; --i) {
            FlatLayer layer = layers[i];
            FlatLayer nextLayer = null;
            if (i > 0) {
                nextLayer = layers[i - 1];
            }
            this.biasActivation[index] = layer.getBiasActivation();
            this.layerCounts[index] = layer.getTotalCount();
            this.layerFeedCounts[index] = layer.getCount();
            this.layerContextCount[index] = layer.getContectCount();
            this.activationFunctions[index] = layer.getActivation();
            neuronCount += layer.getTotalCount();
            if (nextLayer != null) {
                weightCount += layer.getCount() * nextLayer.getTotalCount();
            }
            if (index == 0) {
                this.weightIndex[index] = 0;
                this.layerIndex[index] = 0;
            } else {
                this.weightIndex[index] = this.weightIndex[index - 1] + this.layerCounts[index] * this.layerFeedCounts[index - 1];
                this.layerIndex[index] = this.layerIndex[index - 1] + this.layerCounts[index - 1];
            }
            int neuronIndex = 0;
            for (int j = layers.length - 1; j >= 0; --j) {
                if (layers[j].getContextFedBy() == layer) {
                    this.contextTargetSize[i] = layers[j].getContectCount();
                    this.contextTargetOffset[i] = neuronIndex + layers[j].getTotalCount() - layers[j].getContectCount();
                }
                neuronIndex += layers[j].getTotalCount();
            }
            ++index;
        }
        this.beginTraining = 0;
        this.endTraining = this.layerCounts.length - 1;
        this.weights = new double[weightCount];
        this.layerOutput = new double[neuronCount];
        this.clearContext();
    }

    public void randomize() {
        this.randomize(1.0, -1.0);
    }

    public void randomize(double hi, double lo) {
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = Math.random() * (hi - lo) + lo;
        }
    }

    public int getBeginTraining() {
        return this.beginTraining;
    }

    public void setBeginTraining(int beginTraining) {
        this.beginTraining = beginTraining;
    }

    public int getEndTraining() {
        return this.endTraining;
    }

    public void setEndTraining(int endTraining) {
        this.endTraining = endTraining;
    }

    public double getConnectionLimit() {
        return this.connectionLimit;
    }

    public void setConnectionLimit(double connectionLimit) {
        this.connectionLimit = connectionLimit;
        if (this.connectionLimit > 1.0E-6) {
            this.isLimited = true;
        }
    }

    public boolean isLimited() {
        return this.isLimited;
    }

    public void clearConnectionLimit() {
        this.connectionLimit = 0.0;
        this.isLimited = false;
    }

    public ActivationFunction[] getActivationFunctions() {
        return this.activationFunctions;
    }
}

