/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.flat;

import org.encog.engine.EngineMachineLearning;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.validate.BasicMachineLearningValidate;

public class ValidateForOpenCL
extends BasicMachineLearningValidate {
    @Override
    public String isValid(EngineMachineLearning network) {
        if (!(network instanceof FlatNetwork)) {
            return "Only flat networks are valid to be used for OpenCL";
        }
        FlatNetwork flat = (FlatNetwork)network;
        for (ActivationFunction activation : flat.getActivationFunctions()) {
            if (activation.getOpenCLExpression(true) != null) continue;
            return "Can't use OpenCL if activation function does not have an OpenCL expression.";
        }
        if (flat.hasSameActivationFunction() == null) {
            return "Can't use OpenCL training on a neural network that uses multiple activation functions.";
        }
        boolean hasContext = false;
        for (int i = 0; i < flat.getLayerCounts().length; ++i) {
            if (flat.getContextTargetOffset()[i] != 0) {
                hasContext = true;
            }
            if (flat.getContextTargetSize()[i] == 0) continue;
            hasContext = true;
        }
        if (hasContext) {
            return "Can't use OpenCL if context neurons are present.";
        }
        return null;
    }
}

