/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineIndexableSet;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.exceptions.OpenCLError;
import org.encog.engine.opencl.kernels.EncogKernel;

public class OpenCLTrainingProfile {
    private EncogCLDevice device;
    private final double localRatio;
    private final int globalRatio;
    private final double segmentationRatio;
    private int kernelGlobalWorkgroup;
    private int kernelLocalWorkgroup;
    private int kernelWorkPerCall;
    private int kernelNumberOfCalls;
    private int kernelRemainder;
    private int kernelRemainderGlobal;
    private int kernelRemainderPer;

    public OpenCLTrainingProfile(EncogCLDevice device) {
        this(device, 1.0, 1, 1.0);
    }

    public OpenCLTrainingProfile(EncogCLDevice device, double localRatio, int globalRatio, double segmentationRatio) {
        this.device = device;
        if (localRatio < 0.0 || globalRatio < 0 || segmentationRatio < 0.0) {
            throw new OpenCLError("None of the ratios can be below zero.");
        }
        if (localRatio > 1.0) {
            throw new OpenCLError("The local ratio cannot be greater than 1.0.  That would cause the OpenCL device to have more local items than it can handle.");
        }
        if ((double)globalRatio < 1.0) {
            throw new OpenCLError("The global ratio cannot be less than 1.0.  That would cause the global work area to be less than a local work area.");
        }
        if (segmentationRatio > 1.0) {
            throw new OpenCLError("The segmentation ratio cannot be greater than 1.0.  That would cause the trainer to require more training elements per iteration than exist.");
        }
        this.localRatio = localRatio;
        this.globalRatio = globalRatio;
        this.segmentationRatio = segmentationRatio;
    }

    public void calculateKernelParams(EncogKernel kernel, EngineIndexableSet training) {
        int workPerIteration;
        boolean globalValuesAssigned = false;
        if (Math.abs(this.segmentationRatio - 1.0) < 1.0E-6) {
            int trialLocalSize = (int)Math.min((long)kernel.getMaxWorkGroupSize(), training.getRecordCount());
            ++trialLocalSize;
            do {
                this.kernelLocalWorkgroup = (int)((double)(--trialLocalSize) * this.localRatio);
                this.kernelGlobalWorkgroup = this.kernelLocalWorkgroup * this.globalRatio;
                this.kernelWorkPerCall = (int)((double)(training.getRecordCount() / (long)this.kernelGlobalWorkgroup) * this.segmentationRatio);
            } while ((long)(workPerIteration = this.kernelGlobalWorkgroup * this.kernelWorkPerCall) != training.getRecordCount() && trialLocalSize > 1);
            if (trialLocalSize > 0) {
                globalValuesAssigned = true;
            }
        }
        if (!globalValuesAssigned) {
            int maxLocalSize = (int)Math.min((long)kernel.getMaxWorkGroupSize(), training.getRecordCount());
            this.kernelLocalWorkgroup = (int)((double)maxLocalSize * this.localRatio);
            this.kernelGlobalWorkgroup = this.kernelLocalWorkgroup * this.globalRatio;
            if (this.segmentationRatio < 1.0E-6) {
                this.kernelWorkPerCall = 1;
            } else {
                this.kernelWorkPerCall = (int)((double)(training.getRecordCount() / (long)this.kernelGlobalWorkgroup) * this.segmentationRatio);
                if (this.kernelWorkPerCall == 0) {
                    this.kernelWorkPerCall = 1;
                }
            }
        }
        workPerIteration = this.kernelGlobalWorkgroup * this.kernelWorkPerCall;
        this.kernelNumberOfCalls = (int)(training.getRecordCount() / (long)workPerIteration);
        this.kernelRemainder = (int)(training.getRecordCount() % (long)workPerIteration);
        this.kernelRemainderGlobal = this.kernelGlobalWorkgroup;
        if (this.kernelRemainder == 0) {
            this.kernelRemainder = this.kernelGlobalWorkgroup;
            this.kernelRemainderPer = this.kernelWorkPerCall;
            --this.kernelNumberOfCalls;
        } else {
            this.kernelRemainderPer = this.kernelRemainder / this.kernelGlobalWorkgroup;
        }
        if (this.kernelRemainderPer == 0) {
            this.kernelRemainderPer = 1;
            this.kernelRemainderGlobal = this.kernelRemainder;
        }
    }

    public EncogCLDevice getDevice() {
        return this.device;
    }

    public int getGlobalRatio() {
        return this.globalRatio;
    }

    public int getKernelGlobalWorkgroup() {
        return this.kernelGlobalWorkgroup;
    }

    public int getKernelLocalWorkgroup() {
        return this.kernelLocalWorkgroup;
    }

    public int getKernelNumberOfCalls() {
        return this.kernelNumberOfCalls;
    }

    public int getKernelRemainder() {
        return this.kernelRemainder;
    }

    public int getKernelRemainderGlobal() {
        return this.kernelRemainderGlobal;
    }

    public int getKernelRemainderPer() {
        return this.kernelRemainderPer;
    }

    public int getKernelWorkPerCall() {
        return this.kernelWorkPerCall;
    }

    public double getLocalRatio() {
        return this.localRatio;
    }

    public double getSegmentationRatio() {
        return this.segmentationRatio;
    }

    public void setDevice(EncogCLDevice device) {
        this.device = device;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("OpenCL Profile:\n");
        result.append("Local Ratio: ");
        result.append(this.localRatio);
        result.append("\n");
        result.append("Number of global work items: ");
        result.append(this.globalRatio);
        result.append("\n");
        result.append("Segmentation Ratio: ");
        result.append(this.segmentationRatio);
        result.append("\n");
        result.append("Device: ");
        result.append(this.device.toString());
        result.append("\n");
        result.append("kernelGlobalWorkgroup: ");
        result.append(this.kernelGlobalWorkgroup);
        result.append("\n");
        result.append("kernelLocalWorkgroup: ");
        result.append(this.kernelLocalWorkgroup);
        result.append("\n");
        result.append("kernelWorkPerCall: ");
        result.append(this.kernelWorkPerCall);
        result.append("\n");
        result.append("kernelNumberOfCalls: ");
        result.append(this.kernelNumberOfCalls);
        result.append("\n");
        result.append("kernelRemainder: ");
        result.append(this.kernelRemainder);
        result.append("\n");
        result.append("kernelRemainderGlobal: ");
        result.append(this.kernelRemainderGlobal);
        result.append("\n");
        result.append("kernelRemainderPer: ");
        result.append(this.kernelRemainderPer);
        result.append("\n");
        return result.toString();
    }
}

