/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.network.train.prop;

import org.encog.engine.data.EngineDataSet;
import org.encog.engine.network.flat.FlatNetwork;
import org.encog.engine.network.train.prop.TrainFlatNetworkProp;

public class TrainFlatNetworkBackPropagation
extends TrainFlatNetworkProp {
    private double learningRate;
    private double momentum;
    private double[] lastDelta;

    public TrainFlatNetworkBackPropagation(FlatNetwork network, EngineDataSet training, double learningRate, double momentum) {
        super(network, training);
        this.momentum = momentum;
        this.learningRate = learningRate;
        this.lastDelta = new double[network.getWeights().length];
    }

    public double[] getLastDelta() {
        return this.lastDelta;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setLastDelta(double[] ds) {
        this.lastDelta = ds;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    public void setMomentum(double rate) {
        this.momentum = rate;
    }

    @Override
    public double updateWeight(double[] gradients, double[] lastGradient, int index) {
        double delta;
        this.lastDelta[index] = delta = gradients[index] * this.learningRate + this.lastDelta[index] * this.momentum;
        return delta;
    }
}

