/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import org.encog.engine.opencl.EncogCLItem;
import org.encog.engine.opencl.EncogCLPlatform;
import org.encog.engine.opencl.EncogCLQueue;
import org.encog.engine.util.Format;
import org.jocl.CL;
import org.jocl.Pointer;
import org.jocl.cl_device_id;

public class EncogCLDevice
extends EncogCLItem {
    private final cl_device_id device;
    private final EncogCLPlatform platform;
    private final boolean cpu;
    private final EncogCLQueue queue;

    public EncogCLDevice(EncogCLPlatform platform, cl_device_id device) {
        this.platform = platform;
        this.setEnabled(true);
        this.device = device;
        this.setName(this.getDeviceString(4139).trim());
        this.setVender(this.getDeviceString(4140));
        long type = this.getDeviceLong(4096);
        this.cpu = type == 2L;
        this.queue = new EncogCLQueue(this);
    }

    public cl_device_id getDevice() {
        return this.device;
    }

    public long getDeviceLong(int param) {
        long[] result = new long[1];
        long[] len = new long[1];
        CL.clGetDeviceInfo((cl_device_id)this.device, (int)param, (long)8L, (Pointer)Pointer.to((long[])result), (long[])len);
        return result[0];
    }

    public String getDeviceString(int param) {
        byte[] buffer = new byte[255];
        long[] len = new long[1];
        CL.clGetDeviceInfo((cl_device_id)this.device, (int)param, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), (long[])len);
        String value = new String(buffer, 0, (int)len[0]);
        return value;
    }

    public long getGlobalMemorySize() {
        return this.getDeviceLong(4127);
    }

    public long getLocalMemorySize() {
        return this.getDeviceLong(4131);
    }

    public long getMaxClockFrequency() {
        return this.getDeviceLong(4108);
    }

    public long getMaxComputeUnits() {
        return this.getDeviceLong(4098);
    }

    public long getMaxWorkGroupSize() {
        return this.getDeviceLong(4100);
    }

    public EncogCLPlatform getPlatform() {
        return this.platform;
    }

    public EncogCLQueue getQueue() {
        return this.queue;
    }

    public boolean isCPU() {
        return this.cpu;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.cpu) {
            builder.append("CPU:");
        } else {
            builder.append("GPU:");
        }
        builder.append(this.getName());
        builder.append(",ComputeUnits:");
        builder.append(this.getMaxComputeUnits());
        builder.append(",ClockFreq:");
        builder.append(this.getMaxClockFrequency());
        builder.append(",LocalMemory=");
        builder.append(Format.formatMemory(this.getLocalMemorySize()));
        builder.append(",GlobalMemory=");
        builder.append(Format.formatMemory(this.getGlobalMemorySize()));
        return builder.toString();
    }
}

