/*
 * Decompiled with CFR 0.152.
 */
package org.encog.engine.opencl;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.opencl.EncogCLItem;
import org.jocl.CL;
import org.jocl.NativePointerObject;
import org.jocl.Pointer;
import org.jocl.Sizeof;
import org.jocl.cl_context;
import org.jocl.cl_context_properties;
import org.jocl.cl_device_id;
import org.jocl.cl_platform_id;

public class EncogCLPlatform
extends EncogCLItem {
    private final cl_platform_id platform;
    private final cl_context context;
    private final List<EncogCLDevice> devices = new ArrayList<EncogCLDevice>();

    public EncogCLPlatform(cl_platform_id platform) {
        long[] numBytes = new long[1];
        this.platform = platform;
        cl_context_properties contextProperties = new cl_context_properties();
        contextProperties.addProperty(4228L, platform);
        this.context = CL.clCreateContextFromType((cl_context_properties)contextProperties, (long)-1L, null, null, null);
        this.setName(this.getPlatformString(2306).trim());
        this.setVender(this.getPlatformString(2307));
        this.setEnabled(true);
        CL.clGetContextInfo((cl_context)this.context, (int)4225, (long)0L, null, (long[])numBytes);
        int numDevices = (int)numBytes[0] / Sizeof.cl_device_id;
        cl_device_id[] devicesList = new cl_device_id[numDevices];
        CL.clGetContextInfo((cl_context)this.context, (int)4225, (long)numBytes[0], (Pointer)Pointer.to((NativePointerObject[])devicesList), null);
        for (cl_device_id deviceID : devicesList) {
            EncogCLDevice adapter = new EncogCLDevice(this, deviceID);
            this.devices.add(adapter);
        }
    }

    public cl_context getContext() {
        return this.context;
    }

    public List<EncogCLDevice> getDevices() {
        return this.devices;
    }

    public cl_platform_id getPlatform() {
        return this.platform;
    }

    public String getPlatformString(int param) {
        byte[] buffer = new byte[255];
        long[] len = new long[1];
        CL.clGetPlatformInfo((cl_platform_id)this.platform, (int)param, (long)buffer.length, (Pointer)Pointer.to((byte[])buffer), (long[])len);
        String name = new String(buffer, 0, (int)len[0]);
        return name;
    }
}

