/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public class LinearCongruentialGenerator {
    private final long modulus;
    private final long multiplier;
    private final long increment;
    private long seed;
    public static final long MAX_RAND = 0xFFFFFFFFL;

    public LinearCongruentialGenerator(long seed) {
        this((long)Math.pow(2.0, 32.0), 1103515245L, 12345L, seed);
    }

    public LinearCongruentialGenerator(long modulus, long multiplier, long increment, long seed) {
        this.modulus = modulus;
        this.multiplier = multiplier;
        this.increment = increment;
        this.seed = seed;
    }

    public long getIncrement() {
        return this.increment;
    }

    public long getModulus() {
        return this.modulus;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public long getSeed() {
        return this.seed;
    }

    public double nextDouble() {
        return (double)this.nextLong() / 4.294967295E9;
    }

    public long nextLong() {
        this.seed = (this.multiplier * this.seed + this.increment) % this.modulus;
        return this.seed;
    }

    public double range(double min, double max) {
        double range = max - min;
        return range * this.nextDouble() - min;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }
}

