/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BiPolarUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static double bipolar2double(boolean b) {
        if (b) {
            return 1.0;
        }
        return -1.0;
    }

    public static double[] bipolar2double(boolean[] b) {
        double[] result = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            result[i] = BiPolarUtil.bipolar2double(b[i]);
        }
        return result;
    }

    public static double[][] bipolar2double(boolean[][] b) {
        double[][] result = new double[b.length][b[0].length];
        for (int row = 0; row < b.length; ++row) {
            for (int col = 0; col < b[0].length; ++col) {
                result[row][col] = BiPolarUtil.bipolar2double(b[row][col]);
            }
        }
        return result;
    }

    public static boolean double2bipolar(double d) {
        return d > 0.0;
    }

    public static boolean[] double2bipolar(double[] d) {
        boolean[] result = new boolean[d.length];
        for (int i = 0; i < d.length; ++i) {
            result[i] = BiPolarUtil.double2bipolar(d[i]);
        }
        return result;
    }

    public static boolean[][] double2bipolar(double[][] d) {
        boolean[][] result = new boolean[d.length][d[0].length];
        for (int row = 0; row < d.length; ++row) {
            for (int col = 0; col < d[0].length; ++col) {
                result[row][col] = BiPolarUtil.double2bipolar(d[row][col]);
            }
        }
        return result;
    }

    public static double normalizeBinary(double d) {
        if (d > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double toBinary(double d) {
        return (d + 1.0) / 2.0;
    }

    public static double toBiPolar(double d) {
        return 2.0 * BiPolarUtil.normalizeBinary(d) - 1.0;
    }

    public static double toNormalizedBinary(double d) {
        return BiPolarUtil.normalizeBinary(BiPolarUtil.toBinary(d));
    }

    private BiPolarUtil() {
    }
}

