/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import java.io.Serializable;
import org.encog.mathutil.matrices.MatrixError;
import org.encog.mathutil.matrices.MatrixMath;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;
import org.encog.mathutil.matrices.decomposition.QRDecomposition;
import org.encog.persist.BasicPersistedSubObject;
import org.encog.persist.Persistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Matrix
extends BasicPersistedSubObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7977897210426471675L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(Matrix.class);
    private final double[][] matrix;

    public static Matrix createColumnMatrix(double[] input) {
        double[][] d = new double[input.length][1];
        for (int row = 0; row < d.length; ++row) {
            d[row][0] = input[row];
        }
        return new Matrix(d);
    }

    public static Matrix createRowMatrix(double[] input) {
        double[][] d = new double[1][input.length];
        System.arraycopy(input, 0, d[0], 0, input.length);
        return new Matrix(d);
    }

    public Matrix(boolean[][] sourceMatrix) {
        this.matrix = new double[sourceMatrix.length][sourceMatrix[0].length];
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                if (sourceMatrix[r][c]) {
                    this.set(r, c, 1.0);
                    continue;
                }
                this.set(r, c, -1.0);
            }
        }
    }

    public Matrix(double[][] sourceMatrix) {
        this.matrix = new double[sourceMatrix.length][sourceMatrix[0].length];
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                this.set(r, c, sourceMatrix[r][c]);
            }
        }
    }

    public Matrix(int rows, int cols) {
        this.matrix = new double[rows][cols];
    }

    public void add(int row, int col, double value) {
        this.validate(row, col);
        double newValue = this.matrix[row][col] + value;
        this.set(row, col, newValue);
    }

    public void add(Matrix matrix) {
        double[][] source = matrix.getData();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                double[] dArray = this.matrix[row];
                int n = col;
                dArray[n] = dArray[n] + source[row][col];
            }
        }
    }

    public void clear() {
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                this.matrix[r][c] = 0.0;
            }
        }
    }

    public Matrix clone() {
        return new Matrix(this.matrix);
    }

    @Override
    public Persistor createPersistor() {
        return null;
    }

    public boolean equals(Matrix matrix, int precision) {
        if (precision < 0) {
            String str = "Precision can't be a negative number.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Precision can't be a negative number.");
            }
            throw new MatrixError("Precision can't be a negative number.");
        }
        double test = Math.pow(10.0, precision);
        if (Double.isInfinite(test) || test > 9.223372036854776E18) {
            String str = "Precision of " + precision + " decimal places is not supported.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(str);
            }
            throw new MatrixError(str);
        }
        int actualPrecision = (int)Math.pow(10.0, precision);
        double[][] data = matrix.getData();
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                if ((long)(this.matrix[r][c] * (double)actualPrecision) == (long)(data[r][c] * (double)actualPrecision)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object other) {
        if (other instanceof Matrix) {
            return this.equals((Matrix)other, 10);
        }
        return false;
    }

    public int fromPackedArray(Double[] array, int index) {
        int i = index;
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                this.matrix[r][c] = array[i++];
            }
        }
        return i;
    }

    public double get(int row, int col) {
        this.validate(row, col);
        return this.matrix[row][col];
    }

    public double[][] getArrayCopy() {
        double[][] result = new double[this.getRows()][this.getCols()];
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                result[i][j] = this.matrix[i][j];
            }
        }
        return result;
    }

    public Matrix getCol(int col) {
        if (col > this.getCols()) {
            String str = "Can't get column #" + col + " because it does not exist.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(str);
            }
            throw new MatrixError(str);
        }
        double[][] newMatrix = new double[this.getRows()][1];
        for (int row = 0; row < this.getRows(); ++row) {
            newMatrix[row][0] = this.matrix[row][col];
        }
        return new Matrix(newMatrix);
    }

    public int getCols() {
        return this.matrix[0].length;
    }

    public double[][] getData() {
        return this.matrix;
    }

    public Matrix getMatrix(int i0, int i1, int j0, int j1) {
        Matrix result = new Matrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] b = result.getData();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    b[i - i0][j - j0] = this.matrix[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int i0, int i1, int[] c) {
        Matrix result = new Matrix(i1 - i0 + 1, c.length);
        double[][] b = result.getData();
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    b[i - i0][j] = this.matrix[i][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int[] r, int j0, int j1) {
        Matrix result = new Matrix(r.length, j1 - j0 + 1);
        double[][] b = result.getData();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    b[i][j - j0] = this.matrix[r[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return result;
    }

    public Matrix getMatrix(int[] r, int[] c) {
        Matrix result = new Matrix(r.length, c.length);
        double[][] b = result.getData();
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    b[i][j] = this.matrix[r[i]][c[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
        return result;
    }

    public Matrix getRow(int row) {
        if (row > this.getRows()) {
            String str = "Can't get row #" + row + " because it does not exist.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(str);
            }
            throw new MatrixError(str);
        }
        double[][] newMatrix = new double[1][this.getCols()];
        for (int col = 0; col < this.getCols(); ++col) {
            newMatrix[0][col] = this.matrix[row][col];
        }
        return new Matrix(newMatrix);
    }

    public int getRows() {
        return this.matrix.length;
    }

    public int hashCode() {
        long result = 0L;
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                result = (long)((double)result + this.matrix[r][c]);
            }
        }
        return (int)(result % Integer.MAX_VALUE);
    }

    public Matrix inverse() {
        return this.solve(MatrixMath.identity(this.getRows()));
    }

    public boolean isVector() {
        if (this.getRows() == 1) {
            return true;
        }
        return this.getCols() == 1;
    }

    public boolean isZero() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                if (this.matrix[row][col] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    public void multiply(double value) {
        for (int row = 0; row < this.getRows(); ++row) {
            int col = 0;
            while (col < this.getCols()) {
                double[] dArray = this.matrix[row];
                int n = col++;
                dArray[n] = dArray[n] * value;
            }
        }
    }

    public void multiply(double[] vector, double[] result) {
        for (int i = 0; i < this.getRows(); ++i) {
            result[i] = 0.0;
            for (int j = 0; j < this.getCols(); ++j) {
                int n = i;
                result[n] = result[n] + this.matrix[i][j] * vector[j];
            }
        }
    }

    public void set(double value) {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.matrix[row][col] = value;
            }
        }
    }

    public void set(int row, int col, double value) {
        this.validate(row, col);
        this.matrix[row][col] = value;
    }

    public void set(Matrix matrix) {
        double[][] source = matrix.getData();
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getCols(); ++col) {
                this.matrix[row][col] = source[row][col];
            }
        }
    }

    public void setMatrix(int i0, int i1, int j0, int j1, Matrix x) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.matrix[i][j] = x.get(i - i0, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public void setMatrix(int i0, int i1, int[] c, Matrix x) {
        try {
            for (int i = i0; i <= i1; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.matrix[i][c[j]] = x.get(i - i0, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int j0, int j1, Matrix x) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = j0; j <= j1; ++j) {
                    this.matrix[r[i]][j] = x.get(i, j - j0);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] r, int[] c, Matrix x) {
        try {
            for (int i = 0; i < r.length; ++i) {
                for (int j = 0; j < c.length; ++j) {
                    this.matrix[r[i]][c[j]] = x.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new MatrixError("Submatrix indices");
        }
    }

    public int size() {
        return this.matrix[0].length * this.matrix.length;
    }

    public Matrix solve(Matrix b) {
        if (this.getRows() == this.getCols()) {
            return new LUDecomposition(this).solve(b);
        }
        return new QRDecomposition(this).solve(b);
    }

    public double sum() {
        double result = 0.0;
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                result += this.matrix[r][c];
            }
        }
        return result;
    }

    public Double[] toPackedArray() {
        Double[] result = new Double[this.getRows() * this.getCols()];
        int index = 0;
        for (int r = 0; r < this.getRows(); ++r) {
            for (int c = 0; c < this.getCols(); ++c) {
                result[index++] = this.matrix[r][c];
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[Matrix: rows=");
        result.append(this.getRows());
        result.append(",cols=");
        result.append(this.getCols());
        result.append("]");
        return result.toString();
    }

    private void validate(int row, int col) {
        if (row >= this.getRows() || row < 0) {
            String str = "The row:" + row + " is out of range:" + this.getRows();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(str);
            }
            throw new MatrixError(str);
        }
        if (col >= this.getCols() || col < 0) {
            String str = "The col:" + col + " is out of range:" + this.getCols();
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(str);
            }
            throw new MatrixError(str);
        }
    }
}

