/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import java.util.Random;
import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.randomize.Randomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.FlatUpdateNeeded;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicRandomizer
implements Randomizer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Random random = new Random(System.currentTimeMillis());

    @Override
    public void randomize(BasicNetwork network) {
        network.getStructure().updateFlatNetwork();
        for (Synapse synapse : network.getStructure().getSynapses()) {
            if (synapse.getMatrix() == null) continue;
            this.randomize(network, synapse);
        }
        for (Layer layer : network.getStructure().getLayers()) {
            if (!layer.hasBias()) continue;
            this.randomize(layer.getBiasWeights());
        }
        network.getStructure().setFlatUpdate(FlatUpdateNeeded.Flatten);
        network.getStructure().flattenWeights();
    }

    public void randomize(BasicNetwork network, Synapse synapse) {
        if (synapse.getMatrix() != null) {
            boolean limited = network.getStructure().isConnectionLimited();
            double[][] d = synapse.getMatrix().getData();
            for (int fromNeuron = 0; fromNeuron < synapse.getMatrix().getRows(); ++fromNeuron) {
                for (int toNeuron = 0; toNeuron < synapse.getMatrix().getCols(); ++toNeuron) {
                    if (limited && !network.isConnected(synapse, fromNeuron, toNeuron)) continue;
                    d[fromNeuron][toNeuron] = this.randomize(d[fromNeuron][toNeuron]);
                }
            }
        }
    }

    @Override
    public void randomize(double[] d) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.randomize(d[i]);
        }
    }

    @Override
    public void randomize(Double[] d) {
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.randomize(d[i]);
        }
    }

    @Override
    public void randomize(double[][] d) {
        for (int r = 0; r < d.length; ++r) {
            for (int c = 0; c < d[0].length; ++c) {
                d[r][c] = this.randomize(d[r][c]);
            }
        }
    }

    @Override
    public void randomize(Double[][] d) {
        for (int r = 0; r < d.length; ++r) {
            for (int c = 0; c < d[0].length; ++c) {
                d[r][c] = this.randomize(d[r][c]);
            }
        }
    }

    @Override
    public void randomize(Matrix m) {
        double[][] d = m.getData();
        for (int r = 0; r < m.getRows(); ++r) {
            for (int c = 0; c < m.getCols(); ++c) {
                d[r][c] = this.randomize(d[r][c]);
            }
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public double nextDouble(double min, double max) {
        double range = max - min;
        return range * this.random.nextDouble() + min;
    }
}

