/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.randomize;

import org.encog.mathutil.LinearCongruentialGenerator;
import org.encog.mathutil.randomize.BasicRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentRandomizer
extends BasicRandomizer {
    private final LinearCongruentialGenerator rand;
    private final double min;
    private final double max;
    private final int seed;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConsistentRandomizer(double min, double max) {
        this(max, min, 1000);
    }

    public ConsistentRandomizer(double min, double max, int seed) {
        this.max = max;
        this.min = min;
        this.seed = seed;
        this.rand = new LinearCongruentialGenerator(seed);
    }

    @Override
    public double randomize(double d) {
        return this.rand.range(this.min, this.max);
    }

    @Override
    public void randomize(BasicNetwork network) {
        this.rand.setSeed(this.seed);
        super.randomize(network);
    }
}

