/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.rbf;

import org.encog.engine.util.BoundMath;
import org.encog.mathutil.rbf.BasicRBF;

public class MultiquadricFunction
extends BasicRBF {
    public MultiquadricFunction(double center, double peak, double width) {
        this.setCenters(new double[1]);
        this.getCenters()[0] = center;
        this.setPeak(peak);
        this.setWidth(width);
    }

    public MultiquadricFunction(double peak, double[] center, double width) {
        this.setCenters(center);
        this.setPeak(peak);
        this.setWidth(width);
    }

    public MultiquadricFunction(int dimensions) {
        this.setCenters(new double[dimensions]);
        this.setPeak(1.0);
        this.setWidth(1.0);
    }

    @Override
    public double calculate(double[] x) {
        double value = 0.0;
        double[] center = this.getCenters();
        double width = this.getWidth();
        for (int i = 0; i < center.length; ++i) {
            value += Math.pow(x[i] - center[i], 2.0) + width * width;
        }
        return this.getPeak() * BoundMath.sqrt(value);
    }
}

