/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.basic;

import java.io.Serializable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicNeuralDataPair
implements NeuralDataPair,
Serializable {
    private static final long serialVersionUID = -9068229682273861359L;
    private final NeuralData ideal;
    private final NeuralData input;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public BasicNeuralDataPair(NeuralData input) {
        this.input = input;
        this.ideal = null;
    }

    public BasicNeuralDataPair(NeuralData input, NeuralData ideal) {
        this.input = input;
        this.ideal = ideal;
    }

    @Override
    public NeuralData getIdeal() {
        return this.ideal;
    }

    @Override
    public NeuralData getInput() {
        return this.input;
    }

    @Override
    public boolean isSupervised() {
        return this.ideal != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[NeuralDataPair:");
        builder.append("Input:");
        builder.append(this.getInput());
        builder.append("Ideal:");
        builder.append(this.getIdeal());
        builder.append("]");
        return builder.toString();
    }

    public static NeuralDataPair createPair(int inputSize, int idealSize) {
        BasicNeuralDataPair result = idealSize > 0 ? new BasicNeuralDataPair(new BasicNeuralData(inputSize), new BasicNeuralData(idealSize)) : new BasicNeuralDataPair(new BasicNeuralData(inputSize));
        return result;
    }

    @Override
    public double[] getIdealArray() {
        return this.ideal.getData();
    }

    @Override
    public double[] getInputArray() {
        return this.input.getData();
    }

    @Override
    public void setIdealArray(double[] data) {
        this.ideal.setData(data);
    }

    @Override
    public void setInputArray(double[] data) {
        this.input.setData(data);
    }
}

