/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.util.Iterator;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.buffer.BufferedNeuralDataSet;

public class BufferedDataSetIterator
implements Iterator<NeuralDataPair> {
    private BufferedNeuralDataSet data;
    private int current;

    public BufferedDataSetIterator(BufferedNeuralDataSet data) {
        this.data = data;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        return (long)this.current < this.data.getRecordCount();
    }

    @Override
    public NeuralDataPair next() {
        if (!this.hasNext()) {
            return null;
        }
        NeuralDataPair pair = BasicNeuralDataPair.createPair(this.data.getInputSize(), this.data.getIdealSize());
        this.data.getRecord(this.current++, pair);
        return pair;
    }

    @Override
    public void remove() {
        throw new NeuralDataError("Remove is not supported.");
    }
}

