/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.engine.data.EngineData;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataSet;
import org.encog.neural.data.buffer.BufferedDataError;
import org.encog.neural.data.buffer.BufferedDataSetIterator;
import org.encog.neural.data.buffer.EncogEGBFile;
import org.encog.persist.BasicPersistedObject;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.BufferedNeuralDataSetPersistor;

public class BufferedNeuralDataSet
extends BasicPersistedObject
implements NeuralDataSet,
Indexable,
Serializable {
    private static final long serialVersionUID = 2577778772598513566L;
    public static final String ERROR_ADD = "Add can only be used after calling beginLoad.";
    public static final String ERROR_REMOVE = "Remove is not supported for BufferedNeuralDataSet.";
    private transient boolean loading;
    private File file;
    private transient EncogEGBFile egb;
    private transient List<BufferedNeuralDataSet> additional = new ArrayList<BufferedNeuralDataSet>();
    private transient BufferedNeuralDataSet owner;

    public BufferedNeuralDataSet(File binaryFile) {
        this.file = binaryFile;
        this.egb = new EncogEGBFile(binaryFile);
        if (this.file.exists()) {
            this.egb.open();
        }
    }

    public void open() {
        this.egb.open();
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new BufferedDataSetIterator(this);
    }

    @Override
    public long getRecordCount() {
        if (this.egb == null) {
            return 0L;
        }
        return this.egb.getNumberOfRecords();
    }

    @Override
    public void getRecord(long index, EngineData pair) {
        double[] inputTarget = pair.getInputArray();
        double[] idealTarget = pair.getIdealArray();
        this.egb.setLocation((int)index);
        this.egb.read(inputTarget);
        this.egb.read(idealTarget);
    }

    @Override
    public BufferedNeuralDataSet openAdditional() {
        BufferedNeuralDataSet result = new BufferedNeuralDataSet(this.file);
        result.setOwner(this);
        this.additional.add(result);
        return result;
    }

    @Override
    public void add(NeuralData data1) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(data1.getData());
    }

    @Override
    public void add(NeuralData inputData, NeuralData idealData) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(inputData.getData());
        this.egb.write(idealData.getData());
    }

    @Override
    public void add(NeuralDataPair pair) {
        if (!this.loading) {
            throw new NeuralDataError(ERROR_ADD);
        }
        this.egb.write(pair.getInputArray());
        this.egb.write(pair.getIdealArray());
    }

    @Override
    public void close() {
        Object[] obj = this.additional.toArray();
        for (int i = 0; i < obj.length; ++i) {
            BufferedNeuralDataSet set = (BufferedNeuralDataSet)obj[i];
            set.close();
        }
        this.additional.clear();
        if (this.owner != null) {
            this.owner.removeAdditional(this);
        }
        this.egb.close();
        this.egb = null;
    }

    @Override
    public int getIdealSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getIdealCount();
    }

    @Override
    public int getInputSize() {
        if (this.egb == null) {
            return 0;
        }
        return this.egb.getInputCount();
    }

    @Override
    public boolean isSupervised() {
        if (this.egb == null) {
            return false;
        }
        return this.egb.getIdealCount() > 0;
    }

    public BufferedNeuralDataSet getOwner() {
        return this.owner;
    }

    public void setOwner(BufferedNeuralDataSet owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditional(BufferedNeuralDataSet child) {
        BufferedNeuralDataSet bufferedNeuralDataSet = this;
        synchronized (bufferedNeuralDataSet) {
            this.additional.remove(child);
        }
    }

    public void beginLoad(int inputSize, int idealSize) {
        this.egb.create(inputSize, idealSize);
        this.loading = true;
    }

    public void endLoad() {
        if (!this.loading) {
            throw new BufferedDataError("Must call beginLoad, before endLoad.");
        }
        this.egb.close();
        this.open();
    }

    @Override
    public Persistor createPersistor() {
        return new BufferedNeuralDataSetPersistor();
    }

    public File getFile() {
        return this.file;
    }

    public EncogEGBFile getEGB() {
        return this.egb;
    }

    public NeuralDataSet loadToMemory() {
        BasicNeuralDataSet result = new BasicNeuralDataSet();
        for (NeuralDataPair pair : this) {
            result.add(pair);
        }
        return result;
    }

    public void load(NeuralDataSet training) {
        this.beginLoad(training.getInputSize(), training.getIdealSize());
        for (NeuralDataPair pair : training) {
            this.add(pair);
        }
        this.endLoad();
    }
}

