/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.buffer.codec;

import java.util.Iterator;
import org.encog.engine.util.EngineArray;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.data.buffer.codec.DataSetCODEC;

public class NeuralDataSetCODEC
implements DataSetCODEC {
    private int inputSize;
    private int idealSize;
    private NeuralDataSet dataset;
    private Iterator<NeuralDataPair> iterator;

    public NeuralDataSetCODEC(NeuralDataSet dataset) {
        this.dataset = dataset;
        this.inputSize = dataset.getInputSize();
        this.idealSize = dataset.getIdealSize();
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public boolean read(double[] input, double[] ideal) {
        if (!this.iterator.hasNext()) {
            return false;
        }
        NeuralDataPair pair = this.iterator.next();
        EngineArray.arrayCopy(pair.getInputArray(), input);
        EngineArray.arrayCopy(pair.getIdealArray(), ideal);
        return true;
    }

    @Override
    public void write(double[] input, double[] ideal) {
        NeuralDataPair pair = BasicNeuralDataPair.createPair(this.inputSize, this.idealSize);
        EngineArray.arrayCopy(input, pair.getIdealArray());
        EngineArray.arrayCopy(ideal, pair.getIdealArray());
    }

    @Override
    public void prepareWrite(int recordCount, int inputSize, int idealSize) {
        this.inputSize = inputSize;
        this.idealSize = idealSize;
    }

    @Override
    public void prepareRead() {
        this.iterator = this.dataset.iterator();
    }

    @Override
    public void close() {
    }
}

