/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.image;

import java.awt.Image;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.normalize.output.OutputFieldRangeMapped;
import org.encog.util.downsample.Downsample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageNeuralData
extends BasicNeuralData {
    private static final long serialVersionUID = -4645971270240180450L;
    private Image image;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ImageNeuralData(Image image) {
        super(1);
        this.image = image;
    }

    public void downsample(Downsample downsampler, boolean findBounds, int height, int width, double hi, double lo) {
        if (findBounds) {
            downsampler.findBounds();
        }
        double[] sample = downsampler.downSample(this.image, height, width);
        for (int i = 0; i < sample.length; ++i) {
            sample[i] = OutputFieldRangeMapped.calculate(sample[i], 0.0, 255.0, hi, lo);
        }
        this.setData(sample);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[ImageNeuralData:");
        for (int i = 0; i < this.getData().length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.getData(i));
        }
        builder.append("]");
        return builder.toString();
    }
}

