/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.market;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.market.MarketDataDescription;
import org.encog.neural.data.market.MarketError;
import org.encog.neural.data.market.TickerSymbol;
import org.encog.neural.data.market.loader.LoadedMarketData;
import org.encog.neural.data.market.loader.MarketLoader;
import org.encog.neural.data.temporal.TemporalDataDescription;
import org.encog.neural.data.temporal.TemporalNeuralDataSet;
import org.encog.neural.data.temporal.TemporalPoint;
import org.encog.util.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketNeuralDataSet
extends TemporalNeuralDataSet {
    private static final long serialVersionUID = 170791819906003867L;
    private final MarketLoader loader;
    private final Map<Integer, TemporalPoint> pointIndex = new HashMap<Integer, TemporalPoint>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MarketNeuralDataSet(MarketLoader loader, int inputWindowSize, int predictWindowSize) {
        super(inputWindowSize, predictWindowSize);
        this.loader = loader;
        this.setSequenceGrandularity(TimeUnit.DAYS);
    }

    @Override
    public void addDescription(TemporalDataDescription desc) {
        if (!(desc instanceof MarketDataDescription)) {
            String str = "Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.";
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.");
            }
            throw new MarketError("Only MarketDataDescription objects may be used with the MarketNeuralDataSet container.");
        }
        super.addDescription(desc);
    }

    @Override
    public TemporalPoint createPoint(Date when) {
        int sequence = this.getSequenceFromDate(when);
        TemporalPoint result = this.pointIndex.get(sequence);
        if (result == null) {
            result = super.createPoint(when);
            this.pointIndex.put(result.getSequence(), result);
        }
        return result;
    }

    public NeuralData generateInputForPrediction(Date date) {
        return null;
    }

    public MarketLoader getLoader() {
        return this.loader;
    }

    public void load(Date begin, Date end) {
        if (this.getStartingPoint() == null) {
            this.setStartingPoint(begin);
        }
        this.getPoints().clear();
        HashSet<TickerSymbol> set = new HashSet<TickerSymbol>();
        for (TemporalDataDescription desc : this.getDescriptions()) {
            MarketDataDescription mdesc = (MarketDataDescription)desc;
            set.add(mdesc.getTicker());
        }
        for (TickerSymbol symbol : set) {
            this.loadSymbol(symbol, begin, end);
        }
        this.sortPoints();
    }

    private void loadPointFromMarketData(TickerSymbol ticker, TemporalPoint point, LoadedMarketData item) {
        for (TemporalDataDescription desc : this.getDescriptions()) {
            MarketDataDescription mdesc = (MarketDataDescription)desc;
            if (!mdesc.getTicker().equals(ticker)) continue;
            point.setData(mdesc.getIndex(), item.getData(mdesc.getDataType()));
        }
    }

    private void loadSymbol(TickerSymbol ticker, Date from, Date to) {
        Collection<LoadedMarketData> data = this.getLoader().load(ticker, null, from, to);
        for (LoadedMarketData item : data) {
            TemporalPoint point = this.createPoint(item.getWhen());
            this.loadPointFromMarketData(ticker, point, item);
        }
    }
}

