/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.data.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataError;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLNeuralDataSet
implements NeuralDataSet {
    public static final String ADD_NOT_SUPPORTED = "Adds are not supported with this dataset, it is read only.";
    public static final String REMOVE_NOT_SUPPORTED = "Removes are not supported with this dataset, it is read only.";
    private Connection connection;
    private PreparedStatement statement;
    private boolean closeConnection;
    private final List<SQLNeuralDataSet> iterators = new ArrayList<SQLNeuralDataSet>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int inputSize;
    private final int idealSize;

    public SQLNeuralDataSet(Connection connection, String sql, int inputSize, int idealSize) {
        this.inputSize = inputSize;
        this.idealSize = idealSize;
        this.connection = connection;
        this.closeConnection = false;
        try {
            this.statement = this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            this.logger.error("Exception", (Throwable)e);
            throw new NeuralDataError(e);
        }
    }

    public SQLNeuralDataSet(String sql, int inputSize, int idealSize, String driver, String url, String uid, String pwd) {
        this.inputSize = inputSize;
        this.idealSize = idealSize;
        this.closeConnection = true;
        try {
            Class.forName(driver);
            this.connection = uid == null || pwd == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, uid, pwd);
            this.statement = this.connection.prepareStatement(sql);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Exception", (Throwable)e);
            throw new NeuralDataError(e);
        }
        catch (SQLException e) {
            this.logger.error("Exception", (Throwable)e);
            throw new NeuralDataError(e);
        }
    }

    @Override
    public void add(NeuralData data1) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralData inputData, NeuralData idealData) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void add(NeuralDataPair inputData) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(ADD_NOT_SUPPORTED);
        }
        throw new NeuralDataError(ADD_NOT_SUPPORTED);
    }

    @Override
    public void close() {
        for (SQLNeuralDataSet i : this.iterators) {
            i.close();
        }
        try {
            this.statement.close();
            if (this.closeConnection) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("Exception", (Throwable)e);
            throw new NeuralDataError(e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getIdealSize() {
        return this.idealSize;
    }

    @Override
    public int getInputSize() {
        return this.inputSize;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean isCloseConnection() {
        return this.closeConnection;
    }

    @Override
    public Iterator<NeuralDataPair> iterator() {
        return new SQLNeuralIterator();
    }

    public void setCloseConnection(boolean closeConnection) {
        this.closeConnection = closeConnection;
    }

    @Override
    public boolean isSupervised() {
        return this.idealSize > 0;
    }

    public class SQLNeuralIterator
    implements Iterator<NeuralDataPair> {
        private final ResultSet results;
        private boolean dataReady;

        public SQLNeuralIterator() {
            try {
                this.results = SQLNeuralDataSet.this.statement.executeQuery();
            }
            catch (SQLException e) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)e);
                throw new NeuralDataError(e);
            }
        }

        public void close() {
            try {
                this.results.close();
            }
            catch (SQLException e) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)e);
                throw new NeuralDataError(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.dataReady) {
                    return true;
                }
                if (this.results.next()) {
                    this.dataReady = true;
                    return true;
                }
                this.dataReady = false;
                return false;
            }
            catch (SQLException e) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)e);
                throw new NeuralDataError(e);
            }
        }

        @Override
        public NeuralDataPair next() {
            try {
                double d;
                int i;
                BasicNeuralData input = new BasicNeuralData(SQLNeuralDataSet.this.inputSize);
                BasicNeuralData ideal = null;
                for (i = 0; i < SQLNeuralDataSet.this.inputSize; ++i) {
                    d = this.results.getDouble(i + 1);
                    input.setData(i, d);
                }
                if (SQLNeuralDataSet.this.idealSize > 0) {
                    ideal = new BasicNeuralData(SQLNeuralDataSet.this.idealSize);
                    for (i = 0; i < SQLNeuralDataSet.this.idealSize; ++i) {
                        d = this.results.getDouble(SQLNeuralDataSet.this.inputSize + i + 1);
                        ideal.setData(i, d);
                    }
                }
                this.dataReady = false;
                return new BasicNeuralDataPair(input, ideal);
            }
            catch (SQLException e) {
                SQLNeuralDataSet.this.logger.error("Exception", (Throwable)e);
                throw new NeuralDataError(e);
            }
        }

        @Override
        public void remove() {
            if (SQLNeuralDataSet.this.logger.isErrorEnabled()) {
                SQLNeuralDataSet.this.logger.error(SQLNeuralDataSet.REMOVE_NOT_SUPPORTED);
            }
            throw new NeuralDataError(SQLNeuralDataSet.REMOVE_NOT_SUPPORTED);
        }
    }
}

