/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.layers;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.ContextClearable;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.ContextLayerPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextLayer
extends BasicLayer
implements ContextClearable {
    public static final String ERROR = "Bias is not suppoted for a contextlayer.";
    private static final long serialVersionUID = -5588659547177460637L;
    private final NeuralData context;
    private int flatContextIndex = -1;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ContextLayer.class);

    public ContextLayer() {
        this(1);
    }

    public ContextLayer(ActivationFunction activationFunction, int neuronCount) {
        super(activationFunction, false, neuronCount);
        this.context = new BasicNeuralData(neuronCount);
    }

    public ContextLayer(int neuronCount) {
        this(new ActivationTANH(), neuronCount);
    }

    @Override
    public Persistor createPersistor() {
        return new ContextLayerPersistor();
    }

    public NeuralData getContext() {
        return this.context;
    }

    @Override
    public void process(NeuralData pattern) {
        double[] s = pattern.getData();
        double[] t = this.context.getData();
        System.arraycopy(s, 0, t, 0, s.length);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated ContextLayer to {}", (Object)pattern);
        }
    }

    @Override
    public NeuralData recur() {
        return this.context;
    }

    @Override
    public void clearContext() {
        for (int i = 0; i < this.context.size(); ++i) {
            this.context.setData(i, 0.0);
        }
    }

    @Override
    public double[] getBiasWeights() {
        throw new NeuralNetworkError(ERROR);
    }

    @Override
    public double getBiasWeight(int index) {
        throw new NeuralNetworkError(ERROR);
    }

    @Override
    public void setBiasWeights(double[] d) {
        throw new NeuralNetworkError(ERROR);
    }

    @Override
    public void setBiasWeight(int index, double d) {
        throw new NeuralNetworkError(ERROR);
    }

    public int getFlatContextIndex() {
        return this.flatContextIndex;
    }

    public void setFlatContextIndex(int flatContextIndex) {
        this.flatContextIndex = flatContextIndex;
    }
}

