/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.bipolar.BiPolarNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.ARTLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ART1Logic
extends ARTLogic {
    private static final long serialVersionUID = -8430698735871301528L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ART1Logic.class);
    private Layer layerF1;
    private Layer layerF2;
    private Synapse synapseF1toF2;
    private Synapse synapseF2toF1;
    private int winner;
    private double a1 = 1.0;
    private double b1 = 1.5;
    private double c1 = 5.0;
    private double d1 = 0.9;
    private double l = 3.0;
    private double vigilance = 0.9;
    private boolean[] inhibitF2;
    private int noWinner;
    private BiPolarNeuralData outputF1;
    private BiPolarNeuralData outputF2;

    public void adjustWeights() {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            if (this.outputF1.getBoolean(i)) {
                double magnitudeInput = this.magnitude(this.outputF1);
                this.synapseF1toF2.getMatrix().set(i, this.winner, 1.0);
                this.synapseF2toF1.getMatrix().set(this.winner, i, this.l / (this.l - 1.0 + magnitudeInput));
                continue;
            }
            this.synapseF1toF2.getMatrix().set(i, this.winner, 0.0);
            this.synapseF2toF1.getMatrix().set(this.winner, i, 0.0);
        }
    }

    public void compute(BiPolarNeuralData input, BiPolarNeuralData output) {
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            this.inhibitF2[i] = false;
        }
        boolean resonance = false;
        boolean exhausted = false;
        do {
            this.setInput(input);
            this.computeF2();
            this.getOutput(output);
            if (this.winner != this.noWinner) {
                this.computeF1(input);
                double magnitudeInput1 = this.magnitude(input);
                double magnitudeInput2 = this.magnitude(this.outputF1);
                if (magnitudeInput2 / magnitudeInput1 < this.vigilance) {
                    this.inhibitF2[this.winner] = true;
                    continue;
                }
                resonance = true;
                continue;
            }
            exhausted = true;
        } while (!resonance && !exhausted);
        if (resonance) {
            this.adjustWeights();
        }
    }

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        if (!(input instanceof BiPolarNeuralData)) {
            String str = "Input to ART1 logic network must be BiPolarNeuralData.";
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Input to ART1 logic network must be BiPolarNeuralData.");
            }
            throw new NeuralNetworkError("Input to ART1 logic network must be BiPolarNeuralData.");
        }
        BiPolarNeuralData output = new BiPolarNeuralData(this.layerF1.getNeuronCount());
        this.compute((BiPolarNeuralData)input, output);
        return output;
    }

    private void computeF1(BiPolarNeuralData input) {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            double sum = this.synapseF1toF2.getMatrix().get(i, this.winner) * (double)(this.outputF2.getBoolean(this.winner) ? 1 : 0);
            double activation = ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum - this.b1) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.d1 * sum) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
        }
    }

    private void computeF2() {
        double maxOut = Double.NEGATIVE_INFINITY;
        this.winner = this.noWinner;
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            if (!this.inhibitF2[i]) {
                double sum = 0.0;
                for (int j = 0; j < this.layerF1.getNeuronCount(); ++j) {
                    sum += this.synapseF2toF1.getMatrix().get(i, j) * (double)(this.outputF1.getBoolean(j) ? 1 : 0);
                }
                if (sum > maxOut) {
                    maxOut = sum;
                    this.winner = i;
                }
            }
            this.outputF2.setData(i, false);
        }
        if (this.winner != this.noWinner) {
            this.outputF2.setData(this.winner, true);
        }
    }

    public double getA1() {
        return this.a1;
    }

    public double getB1() {
        return this.b1;
    }

    public double getC1() {
        return this.c1;
    }

    public double getD1() {
        return this.d1;
    }

    public double getL() {
        return this.l;
    }

    private void getOutput(BiPolarNeuralData output) {
        for (int i = 0; i < this.layerF2.getNeuronCount(); ++i) {
            output.setData(i, this.outputF2.getBoolean(i));
        }
    }

    public double getVigilance() {
        return this.vigilance;
    }

    public int getWinner() {
        return this.winner;
    }

    public boolean hasWinner() {
        return this.winner != this.noWinner;
    }

    @Override
    public void init(BasicNetwork network) {
        super.init(network);
        this.layerF1 = this.getNetwork().getLayer("F1");
        this.layerF2 = this.getNetwork().getLayer("F2");
        this.inhibitF2 = new boolean[this.layerF2.getNeuronCount()];
        this.synapseF1toF2 = this.getNetwork().getStructure().findSynapse(this.layerF1, this.layerF2, true);
        this.synapseF2toF1 = this.getNetwork().getStructure().findSynapse(this.layerF2, this.layerF1, true);
        this.outputF1 = new BiPolarNeuralData(this.layerF1.getNeuronCount());
        this.outputF2 = new BiPolarNeuralData(this.layerF2.getNeuronCount());
        this.a1 = this.getNetwork().getPropertyDouble("A1");
        this.b1 = this.getNetwork().getPropertyDouble("B1");
        this.c1 = this.getNetwork().getPropertyDouble("C1");
        this.d1 = this.getNetwork().getPropertyDouble("D1");
        this.l = this.getNetwork().getPropertyDouble("L");
        this.vigilance = this.getNetwork().getPropertyDouble("VIGILANCE");
        this.noWinner = this.layerF2.getNeuronCount();
        this.reset();
    }

    public double magnitude(BiPolarNeuralData input) {
        double result = 0.0;
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            result += input.getBoolean(i) ? 1.0 : 0.0;
        }
        return result;
    }

    public void reset() {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            for (int j = 0; j < this.layerF2.getNeuronCount(); ++j) {
                this.synapseF1toF2.getMatrix().set(i, j, (this.b1 - 1.0) / this.d1 + 0.2);
                this.synapseF2toF1.getMatrix().set(j, i, this.l / (this.l - 1.0 + (double)this.layerF1.getNeuronCount()) - 0.1);
            }
        }
    }

    public void setA1(double a1) {
        this.a1 = a1;
    }

    public void setB1(double b1) {
        this.b1 = b1;
    }

    public void setC1(double c1) {
        this.c1 = c1;
    }

    public void setD1(double d1) {
        this.d1 = d1;
    }

    private void setInput(BiPolarNeuralData input) {
        for (int i = 0; i < this.layerF1.getNeuronCount(); ++i) {
            double activation = (double)(input.getBoolean(i) ? 1 : 0) / (1.0 + this.a1 * ((double)(input.getBoolean(i) ? 1 : 0) + this.b1) + this.c1);
            this.outputF1.setData(i, activation > 0.0);
        }
    }

    public void setL(double l) {
        this.l = l;
    }

    public void setVigilance(double vigilance) {
        this.vigilance = vigilance;
    }
}

