/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralDataMapping;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BAMLogic
implements NeuralLogic {
    private static final long serialVersionUID = 246153941060562476L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(BAMLogic.class);
    private BasicNetwork network;
    private Layer f1Layer;
    private Layer f2Layer;
    private Synapse synapseF1ToF2;
    private Synapse synapseF2ToF1;

    public void addPattern(NeuralData inputPattern, NeuralData outputPattern) {
        for (int i = 0; i < this.getF1Neurons(); ++i) {
            for (int j = 0; j < this.getF2Neurons(); ++j) {
                int weight = (int)(inputPattern.getData(i) * outputPattern.getData(j));
                this.synapseF1ToF2.getMatrix().add(i, j, weight);
                this.synapseF2ToF1.getMatrix().add(j, i, weight);
            }
        }
    }

    public void clear() {
        this.synapseF1ToF2.getMatrix().clear();
        this.synapseF2ToF1.getMatrix().clear();
    }

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        String str = "Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.";
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.");
        }
        throw new NeuralNetworkError("Compute on BasicNetwork cannot be used, rather call the compute(NeuralData) method on the BAMLogic.");
    }

    public NeuralDataMapping compute(NeuralDataMapping input) {
        boolean stable1 = true;
        boolean stable2 = true;
        do {
            stable1 = this.propagateLayer(this.synapseF1ToF2, input.getFrom(), input.getTo());
            stable2 = this.propagateLayer(this.synapseF2ToF1, input.getTo(), input.getFrom());
        } while (!stable1 && !stable2);
        return null;
    }

    public int getF1Neurons() {
        return this.f1Layer.getNeuronCount();
    }

    public int getF2Neurons() {
        return this.f2Layer.getNeuronCount();
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    private double getWeight(Synapse synapse, NeuralData input, int x, int y) {
        if (synapse.getFromNeuronCount() != input.size()) {
            return synapse.getMatrix().get(x, y);
        }
        return synapse.getMatrix().get(y, x);
    }

    @Override
    public void init(BasicNetwork network) {
        this.network = network;
        this.f1Layer = network.getLayer("F1");
        this.f2Layer = network.getLayer("F2");
        this.synapseF1ToF2 = network.getStructure().findSynapse(this.f1Layer, this.f2Layer, true);
        this.synapseF2ToF1 = network.getStructure().findSynapse(this.f2Layer, this.f1Layer, true);
    }

    private boolean propagateLayer(Synapse synapse, NeuralData input, NeuralData output) {
        int out = 0;
        boolean stable = true;
        for (int i = 0; i < output.size(); ++i) {
            int sum = 0;
            for (int j = 0; j < input.size(); ++j) {
                sum = (int)((double)sum + this.getWeight(synapse, input, i, j) * input.getData(j));
            }
            if (sum == 0 || (out = sum < 0 ? -1 : 1) == (int)output.getData(i)) continue;
            stable = false;
            output.setData(i, out);
        }
        return stable;
    }
}

