/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.logic;

import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.logic.NeuralLogic;
import org.encog.neural.networks.synapse.Synapse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedforwardLogic
implements NeuralLogic {
    private static final long serialVersionUID = 1779691422598188487L;
    private static final transient Logger LOGGER = LoggerFactory.getLogger(FeedforwardLogic.class);
    private BasicNetwork network;

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        if (useHolder == null && this.network.getStructure().getFlat() != null) {
            this.network.getStructure().updateFlatNetwork();
            BasicNeuralData result = new BasicNeuralData(this.network.getStructure().getFlat().getOutputCount());
            this.network.getStructure().getFlat().compute(input.getData(), result.getData());
            return result;
        }
        this.network.getStructure().updateFlatNetwork();
        Layer inputLayer = this.network.getLayer("INPUT");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pattern {} presented to neural network", (Object)input);
        }
        NeuralOutputHolder holder = useHolder == null ? new NeuralOutputHolder() : useHolder;
        this.compute(holder, inputLayer, input, null);
        return holder.getOutput();
    }

    private void compute(NeuralOutputHolder holder, Layer layer, NeuralData input, Synapse source) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing layer: {}, input= {}", (Object)layer, (Object)input);
            }
            this.network.getStructure().updateFlatNetwork();
            this.preprocessLayer(layer, input, source);
            for (Synapse synapse : layer.getNext()) {
                if (holder.getResult().containsKey(synapse)) continue;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing synapse: {}", (Object)synapse);
                }
                NeuralData pattern = synapse.compute(input);
                pattern = synapse.getToLayer().compute(pattern);
                synapse.getToLayer().process(pattern);
                holder.getResult().put(synapse, input);
                this.compute(holder, synapse.getToLayer(), pattern, synapse);
                Layer outputLayer = this.network.getLayer("OUTPUT");
                if (synapse.getToLayer() != outputLayer) continue;
                holder.setOutput(pattern);
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new NeuralNetworkError("Size mismatch on input of size " + input.size() + " and layer: ", ex);
        }
    }

    public BasicNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void init(BasicNetwork network) {
        this.network = network;
    }

    public void preprocessLayer(Layer layer, NeuralData input, Synapse source) {
    }
}

