/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.structure;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;

public class CalculateDepth {
    private final Map<Layer, Integer> depths = new HashMap<Layer, Integer>();
    private final BasicNetwork network;
    private final Layer outputLayer;

    public CalculateDepth(BasicNetwork network) {
        this.network = network;
        this.outputLayer = network.getLayer("OUTPUT");
        this.calculate(0, this.outputLayer);
    }

    private void calculate(int currentDepth, Layer layer) {
        if (this.depths.containsKey(layer)) {
            int oldDepth = this.depths.get(layer);
            if (currentDepth > oldDepth) {
                this.depths.put(layer, currentDepth);
            }
        } else {
            this.depths.put(layer, currentDepth);
        }
        Collection<Layer> prev = this.network.getStructure().getPreviousLayers(layer);
        for (Layer nextLayer : prev) {
            if (this.depths.containsKey(nextLayer)) continue;
            this.calculate(currentDepth + 1, nextLayer);
        }
    }

    public int getDepth(Layer layer) {
        if (!this.depths.containsKey(layer)) {
            return -1;
        }
        return this.depths.get(layer);
    }
}

