/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.svm;

import org.encog.mathutil.libsvm.svm;
import org.encog.mathutil.libsvm.svm_model;
import org.encog.mathutil.libsvm.svm_node;
import org.encog.mathutil.libsvm.svm_parameter;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.svm.KernelType;
import org.encog.neural.networks.svm.SVMType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.SVMNetworkPersistor;

public class SVMNetwork
extends BasicNetwork {
    private svm_model[] models;
    private svm_parameter[] params;
    private int inputCount;
    private int outputCount;
    private KernelType kernelType;
    private SVMType svmType;

    public SVMNetwork(int inputCount, int outputCount, SVMType svmType, KernelType kernelType) {
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.kernelType = kernelType;
        this.svmType = svmType;
        this.models = new svm_model[outputCount];
        this.params = new svm_parameter[outputCount];
        for (int i = 0; i < outputCount; ++i) {
            this.params[i] = new svm_parameter();
            switch (svmType) {
                case SupportVectorClassification: {
                    this.params[i].svm_type = 0;
                    break;
                }
                case NewSupportVectorClassification: {
                    this.params[i].svm_type = 1;
                    break;
                }
                case SupportVectorOneClass: {
                    this.params[i].svm_type = 2;
                    break;
                }
                case EpsilonSupportVectorRegression: {
                    this.params[i].svm_type = 3;
                    break;
                }
                case NewSupportVectorRegression: {
                    this.params[i].svm_type = 4;
                }
            }
            switch (kernelType) {
                case Linear: {
                    this.params[i].kernel_type = 0;
                    break;
                }
                case Poly: {
                    this.params[i].kernel_type = 1;
                    break;
                }
                case RadialBasisFunction: {
                    this.params[i].kernel_type = 2;
                    break;
                }
                case Sigmoid: {
                    this.params[i].kernel_type = 3;
                    break;
                }
                case Precomputed: {
                    this.params[i].kernel_type = 4;
                }
            }
            this.params[i].kernel_type = 2;
            this.params[i].degree = 3;
            this.params[i].coef0 = 0.0;
            this.params[i].nu = 0.5;
            this.params[i].cache_size = 100.0;
            this.params[i].C = 1.0;
            this.params[i].eps = 0.001;
            this.params[i].p = 0.1;
            this.params[i].shrinking = 1;
            this.params[i].probability = 0;
            this.params[i].nr_weight = 0;
            this.params[i].weight_label = new int[0];
            this.params[i].weight = new double[0];
            this.params[i].gamma = 1.0 / (double)inputCount;
        }
    }

    public SVMNetwork(int inputCount, int outputCount, boolean regression) {
        this(inputCount, outputCount, regression ? SVMType.EpsilonSupportVectorRegression : SVMType.SupportVectorClassification, KernelType.RadialBasisFunction);
    }

    @Override
    public NeuralData compute(NeuralData input) {
        BasicNeuralData result = new BasicNeuralData(this.outputCount);
        svm_node[] formattedInput = this.makeSparse(input);
        for (int i = 0; i < this.outputCount; ++i) {
            double d = svm.svm_predict(this.models[i], formattedInput);
            result.setData(i, d);
        }
        return result;
    }

    @Override
    public NeuralData compute(NeuralData input, NeuralOutputHolder useHolder) {
        useHolder.setOutput(this.compute(input));
        return useHolder.getOutput();
    }

    public svm_node[] makeSparse(NeuralData data) {
        svm_node[] result = new svm_node[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            result[i] = new svm_node();
            result[i].index = i + 1;
            result[i].value = data.getData(i);
        }
        return result;
    }

    @Override
    public Persistor createPersistor() {
        return new SVMNetworkPersistor();
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    public svm_model[] getModels() {
        return this.models;
    }

    public svm_parameter[] getParams() {
        return this.params;
    }

    public KernelType getKernelType() {
        return this.kernelType;
    }

    public SVMType getSvmType() {
        return this.svmType;
    }
}

