/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse;

import org.encog.mathutil.matrices.Matrix;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.data.NeuralData;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.synapse.BasicSynapse;
import org.encog.neural.networks.synapse.SynapseType;
import org.encog.persist.Persistor;
import org.encog.persist.persistors.DirectSynapsePersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSynapse
extends BasicSynapse {
    private static final long serialVersionUID = -3495349786238542641L;
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public DirectSynapse() {
    }

    public DirectSynapse(Layer fromLayer, Layer toLayer) {
        this.setFromLayer(fromLayer);
        this.setToLayer(toLayer);
    }

    @Override
    public Object clone() {
        DirectSynapse result = new DirectSynapse(this.getFromLayer(), this.getToLayer());
        return result;
    }

    @Override
    public NeuralData compute(NeuralData input) {
        return input;
    }

    @Override
    public Persistor createPersistor() {
        return new DirectSynapsePersistor();
    }

    @Override
    public Matrix getMatrix() {
        return null;
    }

    @Override
    public int getMatrixSize() {
        return 0;
    }

    @Override
    public SynapseType getType() {
        return SynapseType.Direct;
    }

    @Override
    public boolean isTeachable() {
        return false;
    }

    @Override
    public void setMatrix(Matrix matrix) {
        throw new NeuralNetworkError("Can't set the matrix for a DirectSynapse");
    }
}

