/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.synapse.neat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGIgnore;
import org.encog.persist.annotations.EGReferenceable;

@EGReferenceable
public class NEATNeuron
implements Serializable {
    private static final long serialVersionUID = -2815145950124389743L;
    @EGAttribute
    private double activationResponse;
    private final List<NEATLink> inboundLinks = new ArrayList<NEATLink>();
    @EGAttribute
    private long neuronID;
    @EGAttribute
    private NEATNeuronType neuronType;
    @EGAttribute
    private double output;
    private List<NEATLink> outputboundLinks = new ArrayList<NEATLink>();
    @EGAttribute
    private int posX;
    @EGAttribute
    private int posY;
    @EGAttribute
    private double splitX;
    @EGAttribute
    private double splitY;
    @EGIgnore
    private double sumActivation;

    public NEATNeuron() {
    }

    public NEATNeuron(NEATNeuronType neuronType, long neuronID, double splitY, double splitX, double activationResponse) {
        this.neuronType = neuronType;
        this.neuronID = neuronID;
        this.splitY = splitY;
        this.splitX = splitX;
        this.activationResponse = activationResponse;
        this.posX = 0;
        this.posY = 0;
        this.output = 0.0;
        this.sumActivation = 0.0;
    }

    public double getActivationResponse() {
        return this.activationResponse;
    }

    public List<NEATLink> getInboundLinks() {
        return this.inboundLinks;
    }

    public long getNeuronID() {
        return this.neuronID;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getOutput() {
        return this.output;
    }

    public List<NEATLink> getOutputboundLinks() {
        return this.outputboundLinks;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public double getSumActivation() {
        return this.sumActivation;
    }

    public void setOutput(double output) {
        this.output = output;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATNeuron:id=");
        result.append(this.neuronID);
        result.append(",type=");
        switch (this.neuronType) {
            case Input: {
                result.append("I");
                break;
            }
            case Output: {
                result.append("O");
                break;
            }
            case Bias: {
                result.append("B");
                break;
            }
            case Hidden: {
                result.append("H");
                break;
            }
            default: {
                result.append("Unknown");
            }
        }
        result.append("]");
        return result.toString();
    }
}

