/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training;

import org.encog.cloud.CloudTask;
import org.encog.cloud.EncogCloud;
import org.encog.engine.util.Format;
import org.encog.neural.networks.training.Train;

public class TrainingStatusUtility {
    private long lastUpdate;
    private int iteration;
    private final Train train;
    private final EncogCloud cloud;
    private CloudTask task;

    public TrainingStatusUtility(EncogCloud cloud, Train train) {
        this.cloud = cloud;
        this.train = train;
        this.lastUpdate = 0L;
        this.iteration = 0;
    }

    public void finish() {
        StringBuilder status = new StringBuilder();
        status.append("Done at iteration #");
        status.append(Format.formatInteger(this.iteration));
        status.append(" - Error: ");
        status.append(Format.formatPercent(this.train.getError()));
        this.task.stop(status.toString());
        this.task = null;
    }

    public void update() {
        long now = System.currentTimeMillis();
        long elapsed = (now - this.lastUpdate) / 1000L;
        if (this.task == null) {
            this.task = this.cloud.beginTask(this.train.getClass().getSimpleName());
        }
        ++this.iteration;
        if (elapsed > 10L) {
            this.lastUpdate = now;
            StringBuilder status = new StringBuilder();
            status.append("Iteration #");
            status.append(Format.formatInteger(this.iteration));
            status.append(" - Error: ");
            status.append(Format.formatPercent(this.train.getError()));
            this.task.setStatus(status.toString());
        }
    }
}

