/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.competitive.neighborhood;

import org.encog.neural.networks.training.competitive.neighborhood.NeighborhoodFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeighborhoodBubble
implements NeighborhoodFunction {
    private double radius;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public NeighborhoodBubble(int radius) {
        this.radius = radius;
    }

    @Override
    public double function(int currentNeuron, int bestNeuron) {
        int distance = Math.abs(bestNeuron - currentNeuron);
        if ((double)distance <= this.radius) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(double radius) {
        this.radius = radius;
    }
}

