/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.encog.Encog;
import org.encog.NullStatusReportable;
import org.encog.engine.StatusReportable;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerCPU;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerOpenCL;

public final class ConcurrentTrainingManager
implements Runnable {
    private static ConcurrentTrainingManager instance;
    private final Lock accessLock = new ReentrantLock();
    private final Condition mightBeDone = this.accessLock.newCondition();
    private int jobNumber;
    private boolean singleThreaded;
    private final List<ConcurrentTrainingPerformer> performers = new ArrayList<ConcurrentTrainingPerformer>();
    private final List<TrainingJob> queue = new ArrayList<TrainingJob>();
    private Thread thread;
    private StatusReportable report = new NullStatusReportable();

    public static ConcurrentTrainingManager getInstance() {
        if (instance == null) {
            instance = new ConcurrentTrainingManager();
        }
        return instance;
    }

    private ConcurrentTrainingManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerformer(ConcurrentTrainingPerformer performer) {
        try {
            this.accessLock.lock();
            this.performers.add(performer);
            performer.setManager(this);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTrainingJob(TrainingJob job) {
        try {
            this.accessLock.lock();
            this.queue.add(job);
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPerformers() {
        try {
            this.accessLock.lock();
            this.performers.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearQueue() {
        try {
            this.accessLock.lock();
            this.queue.clear();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void detectPerformers() {
        this.detectPerformers(false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectPerformers(boolean splitCores, int forceCoreCount) {
        try {
            this.accessLock.lock();
            boolean useCPU = true;
            this.clearPerformers();
            int clCount = 1;
            int cpuCount = 1;
            this.setSingleThreaded(splitCores);
            if (Encog.getInstance().getCL() != null) {
                if (Encog.getInstance().getCL().areCPUsPresent()) {
                    useCPU = false;
                }
                for (EncogCLDevice device : Encog.getInstance().getCL().getDevices()) {
                    this.addPerformer(new ConcurrentTrainingPerformerOpenCL(clCount++, device));
                }
            }
            if (useCPU && forceCoreCount >= 0) {
                int threads;
                if (splitCores) {
                    Runtime runtime = Runtime.getRuntime();
                    threads = forceCoreCount > 0 ? forceCoreCount : runtime.availableProcessors();
                } else {
                    threads = 1;
                }
                for (int i = 0; i < threads; ++i) {
                    this.addPerformer(new ConcurrentTrainingPerformerCPU(cpuCount++));
                }
            }
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void reportErrors() {
        for (TrainingJob job : this.queue) {
            if (job.getError() == null) continue;
            throw new NeuralNetworkError(job.getError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.jobNumber = 0;
        this.report.report(this.queue.size(), 0, "Starting first job");
        int count = 0;
        for (TrainingJob job : this.queue) {
            ConcurrentTrainingPerformer perform = this.waitForFreePerformer();
            perform.perform(job);
            ++count;
            this.reportErrors();
        }
        boolean done = false;
        this.report.report(this.queue.size(), count, "No more jobs to submit, waiting for last job.");
        while (!done) {
            try {
                this.accessLock.lock();
                boolean foundOne = false;
                for (ConcurrentTrainingPerformer performer : this.performers) {
                    if (performer.ready()) continue;
                    foundOne = true;
                }
                if (foundOne) {
                    try {
                        this.mightBeDone.await();
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                done = true;
            }
            finally {
                this.accessLock.unlock();
            }
        }
        this.report.report(this.queue.size(), count, "All training done.");
    }

    private void reportStatus(String str) {
        this.report.report(this.queue.size(), this.jobNumber, str);
    }

    public void setReport(StatusReportable report) {
        this.report = report;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentTrainingPerformer waitForFreePerformer() {
        try {
            this.accessLock.lock();
            ConcurrentTrainingPerformer result = null;
            while (result == null) {
                for (ConcurrentTrainingPerformer performer : this.performers) {
                    if (!performer.ready()) continue;
                    result = performer;
                }
                if (result != null) continue;
                try {
                    this.mightBeDone.await();
                }
                catch (InterruptedException e) {
                    ConcurrentTrainingPerformer concurrentTrainingPerformer = null;
                    this.accessLock.unlock();
                    return concurrentTrainingPerformer;
                }
            }
            ConcurrentTrainingPerformer concurrentTrainingPerformer = result;
            return concurrentTrainingPerformer;
        }
        finally {
            this.accessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobDone(long time, ConcurrentTrainingPerformerCPU perf) {
        try {
            ++this.jobNumber;
            this.reportStatus("Job finished in " + time + "ms, on " + perf.toString());
            this.accessLock.lock();
            this.mightBeDone.signal();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int index = 1;
        for (ConcurrentTrainingPerformer performer : this.performers) {
            builder.append("Performer ");
            builder.append(index++);
            builder.append(": ");
            builder.append(performer.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public boolean isSingleThreaded() {
        return this.singleThreaded;
    }

    public void setSingleThreaded(boolean singleThreaded) {
        this.singleThreaded = singleThreaded;
    }
}

