/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.back.Backpropagation;

public class BPROPJob
extends TrainingJob {
    private double learningRate;
    private double momentum;

    public BPROPJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory, double learningRate, double momentum) {
        this(network, training, loadToMemory, learningRate, momentum, 1.0, 1, 1.0, 1);
    }

    public BPROPJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory, double learningRate, double momentum, double localRatio, int globalRatio, double segmentationRatio, int iterationsPer) {
        super(network, training, loadToMemory);
        this.learningRate = learningRate;
        this.momentum = momentum;
        this.setLocalRatio(localRatio);
        this.setGlobalRatio(globalRatio);
        this.setSegmentationRatio(segmentationRatio);
        this.setIterationsPer(iterationsPer);
    }

    @Override
    public void createTrainer(OpenCLTrainingProfile profile, boolean singleThreaded) {
        Backpropagation train = new Backpropagation(this.getNetwork(), this.getTraining(), profile, this.getLearningRate(), this.getMomentum());
        if (singleThreaded) {
            train.setNumThreads(1);
        } else {
            train.setNumThreads(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            train.addStrategy(strategy);
        }
        this.setTrain(train);
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public void setMomentum(double momentum) {
        this.momentum = momentum;
    }
}

