/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.Strategy;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;

public class RPROPJob
extends TrainingJob {
    private double initialUpdate;
    private double maxStep;

    public RPROPJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory) {
        this(network, training, loadToMemory, 0.1, 50.0, 1.0, 1, 1.0, 1);
    }

    public RPROPJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory, double localRatio, int globalRatio, double segmentationRatio, int iterationsPer) {
        this(network, training, loadToMemory, 0.1, 50.0, localRatio, globalRatio, segmentationRatio, iterationsPer);
    }

    public RPROPJob(BasicNetwork network, NeuralDataSet training, boolean loadToMemory, double initialUpdate, double maxStep, double localRatio, int globalRatio, double segmentationRatio, int iterationsPer) {
        super(network, training, loadToMemory);
        this.initialUpdate = initialUpdate;
        this.maxStep = maxStep;
        this.setLocalRatio(localRatio);
        this.setGlobalRatio(globalRatio);
        this.setSegmentationRatio(segmentationRatio);
        this.setIterationsPer(iterationsPer);
    }

    @Override
    public void createTrainer(OpenCLTrainingProfile profile, boolean singleThreaded) {
        ResilientPropagation train = new ResilientPropagation(this.getNetwork(), this.getTraining(), profile, this.getInitialUpdate(), this.getMaxStep());
        if (singleThreaded) {
            train.setNumThreads(1);
        } else {
            train.setNumThreads(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            train.addStrategy(strategy);
        }
        this.setTrain(train);
    }

    public double getInitialUpdate() {
        return this.initialUpdate;
    }

    public double getMaxStep() {
        return this.maxStep;
    }

    public void setInitialUpdate(double initialUpdate) {
        this.initialUpdate = initialUpdate;
    }

    public void setMaxStep(double maxStep) {
        this.maxStep = maxStep;
    }
}

