/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.performers;

import java.util.concurrent.atomic.AtomicBoolean;
import org.encog.engine.concurrency.EngineConcurrency;
import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.opencl.EncogCLDevice;
import org.encog.engine.util.Stopwatch;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.training.Train;
import org.encog.neural.networks.training.concurrent.ConcurrentTrainingManager;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformer;
import org.encog.neural.networks.training.concurrent.performers.ConcurrentTrainingPerformerOpenCL;
import org.encog.neural.networks.training.concurrent.performers.PerformerTask;

public class ConcurrentTrainingPerformerCPU
implements ConcurrentTrainingPerformer,
Runnable {
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private TrainingJob currentJob;
    private ConcurrentTrainingManager manager;
    private int number;

    public ConcurrentTrainingPerformerCPU(int number) {
        this.number = number;
    }

    @Override
    public void perform(TrainingJob job) {
        if (!this.ready.get()) {
            throw new NeuralNetworkError("Performer is already performing a job.");
        }
        this.ready.set(false);
        this.currentJob = job;
        PerformerTask task = new PerformerTask(this);
        EngineConcurrency.getInstance().processTask(task);
    }

    @Override
    public boolean ready() {
        return this.ready.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Stopwatch watch = new Stopwatch();
        try {
            watch.start();
            OpenCLTrainingProfile profile = null;
            if (this instanceof ConcurrentTrainingPerformerOpenCL) {
                EncogCLDevice device = ((ConcurrentTrainingPerformerOpenCL)this).getDevice();
                profile = new OpenCLTrainingProfile(device, this.currentJob.getLocalRatio(), this.currentJob.getGlobalRatio(), this.currentJob.getSegmentationRatio());
            }
            this.currentJob.createTrainer(profile, this.manager.isSingleThreaded());
            Train train = this.currentJob.getTrain();
            int interation = 1;
            while (this.currentJob.shouldContinue()) {
                train.iteration(this.currentJob.getIterationsPer());
                ++interation;
            }
            watch.stop();
        }
        catch (Throwable t) {
            this.currentJob.setError(t);
        }
        finally {
            this.ready.set(true);
            this.manager.jobDone(watch.getElapsedMilliseconds(), this);
        }
    }

    public String toString() {
        return "[CPU-Performer: " + this.number + "]";
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public ConcurrentTrainingManager getManager() {
        return this.manager;
    }

    @Override
    public void setManager(ConcurrentTrainingManager manager) {
        this.manager = manager;
    }
}

