/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.genetic;

import org.encog.mathutil.randomize.Randomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.CalculateScore;
import org.encog.neural.networks.training.genetic.GeneticScoreAdapter;
import org.encog.neural.networks.training.genetic.NeuralGenome;
import org.encog.solve.genetic.GeneticAlgorithm;
import org.encog.solve.genetic.crossover.Splice;
import org.encog.solve.genetic.genome.Genome;
import org.encog.solve.genetic.mutate.MutatePerturb;
import org.encog.solve.genetic.population.BasicPopulation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeuralGeneticAlgorithm
extends BasicTraining {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private NeuralGeneticAlgorithmHelper genetic = new NeuralGeneticAlgorithmHelper();

    public NeuralGeneticAlgorithm(BasicNetwork network, Randomizer randomizer, CalculateScore calculateScore, int populationSize, double mutationPercent, double percentToMate) {
        this.genetic.setCalculateScore(new GeneticScoreAdapter(calculateScore));
        BasicPopulation population = new BasicPopulation(populationSize);
        this.getGenetic().setMutationPercent(mutationPercent);
        this.getGenetic().setMatingPopulation(percentToMate * 2.0);
        this.getGenetic().setPercentToMate(percentToMate);
        this.getGenetic().setCrossover(new Splice(network.getStructure().calculateSize() / 3));
        this.getGenetic().setMutate(new MutatePerturb(4.0));
        this.getGenetic().setPopulation(population);
        for (int i = 0; i < population.getPopulationSize(); ++i) {
            BasicNetwork chromosomeNetwork = (BasicNetwork)network.clone();
            randomizer.randomize(chromosomeNetwork);
            NeuralGenome genome = new NeuralGenome(this, chromosomeNetwork);
            this.getGenetic().calculateScore(genome);
            this.getGenetic().getPopulation().add(genome);
        }
        population.sort();
    }

    public NeuralGeneticAlgorithmHelper getGenetic() {
        return this.genetic;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.getGenetic().getNetwork();
    }

    @Override
    public void iteration() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Performing Genetic iteration.");
        }
        this.preIteration();
        this.getGenetic().iteration();
        this.setError(this.getGenetic().getError());
        this.postIteration();
    }

    public void setGenetic(NeuralGeneticAlgorithmHelper genetic) {
        this.genetic = genetic;
    }

    public class NeuralGeneticAlgorithmHelper
    extends GeneticAlgorithm {
        public double getError() {
            Genome genome = this.getPopulation().getBest();
            return genome.getScore();
        }

        public BasicNetwork getNetwork() {
            Genome genome = this.getPopulation().getBest();
            return (BasicNetwork)genome.getOrganism();
        }
    }
}

