/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.lma;

import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.NeuralOutputHolder;
import org.encog.neural.networks.synapse.Synapse;
import org.encog.neural.networks.training.lma.ComputeJacobian;

public class JacobianChainRule
implements ComputeJacobian {
    private final BasicNetwork network;
    private final Indexable indexableTraining;
    private final int inputLength;
    private final int parameterSize;
    private final double[][] jacobian;
    private int jacobianRow;
    private int jacobianCol;
    private final NeuralDataPair pair;
    private final double[] rowErrors;
    private double error;

    public JacobianChainRule(BasicNetwork network, Indexable indexableTraining) {
        this.indexableTraining = indexableTraining;
        this.network = network;
        this.parameterSize = network.getStructure().calculateSize();
        this.inputLength = (int)this.indexableTraining.getRecordCount();
        this.jacobian = new double[this.inputLength][this.parameterSize];
        this.rowErrors = new double[this.inputLength];
        BasicNeuralData input = new BasicNeuralData(this.indexableTraining.getInputSize());
        BasicNeuralData ideal = new BasicNeuralData(this.indexableTraining.getIdealSize());
        this.pair = new BasicNeuralDataPair(input, ideal);
    }

    private double calcDerivative(ActivationFunction a, double d) {
        return a.derivativeFunction(d);
    }

    private double calcDerivative2(ActivationFunction a, double d) {
        double[] temp = new double[]{d};
        a.activationFunction(temp, 0, temp.length);
        temp[0] = a.derivativeFunction(temp[0]);
        return temp[0];
    }

    @Override
    public double calculate(double[] weights) {
        double result = 0.0;
        for (int i = 0; i < this.inputLength; ++i) {
            double e;
            this.jacobianRow = i;
            this.jacobianCol = 0;
            this.indexableTraining.getRecord(i, this.pair);
            this.rowErrors[i] = e = this.calculateDerivatives(this.pair);
            result += e * e;
        }
        return result / 2.0;
    }

    private double calculateDerivatives(NeuralDataPair pair) {
        double e = 0.0;
        double sum = 0.0;
        ActivationFunction function = this.network.getLayer("INPUT").getActivationFunction();
        NeuralOutputHolder holder = new NeuralOutputHolder();
        this.network.compute(pair.getInput(), holder);
        List<Synapse> synapses = this.network.getStructure().getSynapses();
        int synapseNumber = 0;
        Synapse synapse = synapses.get(synapseNumber++);
        double output = holder.getOutput().getData(0);
        e = pair.getIdeal().getData(0) - output;
        for (int i = 0; i < synapse.getFromNeuronCount(); ++i) {
            double lastOutput = holder.getResult().get(synapse).getData(i);
            this.jacobian[this.jacobianRow][this.jacobianCol++] = this.calcDerivative(function, output) * lastOutput;
        }
        this.jacobian[this.jacobianRow][this.jacobianCol++] = this.calcDerivative(function, output);
        while (synapseNumber < synapses.size()) {
            Synapse lastSynapse = synapse;
            synapse = synapses.get(synapseNumber++);
            NeuralData outputData = holder.getResult().get(lastSynapse);
            for (int neuron = 0; neuron < synapse.getToNeuronCount(); ++neuron) {
                output = outputData.getData(neuron);
                double w = lastSynapse.getMatrix().get(neuron, 0);
                double val = this.calcDerivative(function, output) * this.calcDerivative2(function, sum) * w;
                for (int i = 0; i < synapse.getFromNeuronCount(); ++i) {
                    sum = 0.0;
                    for (int j = 0; j < lastSynapse.getToNeuronCount(); ++j) {
                        for (int k = 0; k < lastSynapse.getFromNeuronCount(); ++k) {
                            sum += lastSynapse.getMatrix().get(k, j) * output;
                        }
                        sum += lastSynapse.getToLayer().getBiasWeight(j);
                    }
                    this.jacobian[this.jacobianRow][this.jacobianCol++] = val * holder.getResult().get(synapse).getData(i);
                }
                if (!synapse.getToLayer().hasBias()) continue;
                double[] dArray = this.jacobian[this.jacobianRow];
                int n = this.jacobianCol++;
                dArray[n] = dArray[n] + val;
            }
        }
        return e;
    }

    public double getError() {
        return this.error;
    }

    @Override
    public double[][] getJacobian() {
        return this.jacobian;
    }

    @Override
    public double[] getRowErrors() {
        return this.rowErrors;
    }
}

