/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.lma;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;
import org.encog.neural.data.Indexable;
import org.encog.neural.data.NeuralData;
import org.encog.neural.data.NeuralDataPair;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.data.basic.BasicNeuralData;
import org.encog.neural.data.basic.BasicNeuralDataPair;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.Layer;
import org.encog.neural.networks.structure.NetworkCODEC;
import org.encog.neural.networks.training.BasicTraining;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.lma.JacobianChainRule;

public class LevenbergMarquardtTraining
extends BasicTraining {
    public static final double SCALE_LAMBDA = 10.0;
    public static final double LAMBDA_MAX = 1.0E25;
    private final BasicNetwork network;
    private final Indexable indexableTraining;
    private final int trainingLength;
    private final int parametersLength;
    private double[] weights;
    private final Matrix hessianMatrix;
    private final double[][] hessian;
    private double alpha;
    private double beta;
    private double lambda;
    private final double[] gradient;
    private final double[] diagonal;
    private double[] deltas;
    private double gamma;
    private final NeuralDataPair pair;
    private boolean useBayesianRegularization;

    public static double trace(double[][] m) {
        double result = 0.0;
        for (int i = 0; i < m.length; ++i) {
            result += m[i][i];
        }
        return result;
    }

    public LevenbergMarquardtTraining(BasicNetwork network, NeuralDataSet training) {
        if (!(training instanceof Indexable)) {
            throw new TrainingError("Levenberg Marquardt requires an indexable training set.");
        }
        Layer outputLayer = network.getLayer("OUTPUT");
        if (outputLayer == null) {
            throw new TrainingError("Levenberg Marquardt requires an output layer.");
        }
        if (outputLayer.getNeuronCount() != 1) {
            throw new TrainingError("Levenberg Marquardt requires an output layer with a single neuron.");
        }
        this.setTraining(training);
        this.indexableTraining = (Indexable)this.getTraining();
        this.network = network;
        this.trainingLength = (int)this.indexableTraining.getRecordCount();
        this.parametersLength = this.network.getStructure().calculateSize();
        this.hessianMatrix = new Matrix(this.parametersLength, this.parametersLength);
        this.hessian = this.hessianMatrix.getData();
        this.alpha = 0.0;
        this.beta = 1.0;
        this.lambda = 0.1;
        this.deltas = new double[this.parametersLength];
        this.gradient = new double[this.parametersLength];
        this.diagonal = new double[this.parametersLength];
        BasicNeuralData input = new BasicNeuralData(this.indexableTraining.getInputSize());
        BasicNeuralData ideal = new BasicNeuralData(this.indexableTraining.getIdealSize());
        this.pair = new BasicNeuralDataPair(input, ideal);
    }

    public void calculateHessian(double[][] jacobian, double[] errors) {
        int i;
        for (i = 0; i < this.parametersLength; ++i) {
            int j;
            double s = 0.0;
            for (j = 0; j < this.trainingLength; ++j) {
                s += jacobian[j][i] * errors[j];
            }
            this.gradient[i] = s;
            for (j = 0; j < this.parametersLength; ++j) {
                double c = 0.0;
                for (int k = 0; k < this.trainingLength; ++k) {
                    c += jacobian[k][i] * jacobian[k][j];
                }
                this.hessian[i][j] = this.beta * c;
            }
        }
        for (i = 0; i < this.parametersLength; ++i) {
            this.diagonal[i] = this.hessian[i][i];
        }
    }

    private double calculateSumOfSquaredWeights() {
        double result = 0.0;
        for (double weight : this.weights) {
            result += weight * weight;
        }
        return result / 2.0;
    }

    @Override
    public BasicNetwork getNetwork() {
        return this.network;
    }

    public boolean isUseBayesianRegularization() {
        return this.useBayesianRegularization;
    }

    @Override
    public void iteration() {
        LUDecomposition decomposition = null;
        double trace = 0.0;
        this.preIteration();
        this.weights = NetworkCODEC.networkToArray(this.network);
        JacobianChainRule j = new JacobianChainRule(this.network, this.indexableTraining);
        double sumOfSquaredErrors = j.calculate(this.weights);
        double sumOfSquaredWeights = this.calculateSumOfSquaredWeights();
        this.calculateHessian(j.getJacobian(), j.getRowErrors());
        double objective = this.beta * sumOfSquaredErrors + this.alpha * sumOfSquaredWeights;
        double current = objective + 1.0;
        this.lambda /= 10.0;
        while (current >= objective && this.lambda < 1.0E25) {
            int i;
            this.lambda *= 10.0;
            for (i = 0; i < this.parametersLength; ++i) {
                this.hessian[i][i] = this.diagonal[i] + (this.lambda + this.alpha);
            }
            decomposition = new LUDecomposition(this.hessianMatrix);
            if (!decomposition.isNonsingular()) continue;
            this.deltas = decomposition.Solve(this.gradient);
            sumOfSquaredWeights = this.updateWeights();
            sumOfSquaredErrors = 0.0;
            for (i = 0; i < this.trainingLength; ++i) {
                this.indexableTraining.getRecord(i, this.pair);
                NeuralData actual = this.network.compute(this.pair.getInput());
                double e = this.pair.getIdeal().getData(0) - actual.getData(0);
                sumOfSquaredErrors += e * e;
            }
            current = this.beta * (sumOfSquaredErrors /= 2.0) + this.alpha * sumOfSquaredWeights;
        }
        this.lambda /= 10.0;
        if (this.useBayesianRegularization && decomposition != null) {
            trace = LevenbergMarquardtTraining.trace(decomposition.inverse());
            this.gamma = (double)this.parametersLength - this.alpha * trace;
            this.alpha = (double)this.parametersLength / (2.0 * sumOfSquaredWeights + trace);
            this.beta = Math.abs(((double)this.trainingLength - this.gamma) / (2.0 * sumOfSquaredErrors));
        }
        this.setError(sumOfSquaredErrors);
        this.postIteration();
    }

    public void setUseBayesianRegularization(boolean useBayesianRegularization) {
        this.useBayesianRegularization = useBayesianRegularization;
    }

    public double updateWeights() {
        double result = 0.0;
        double[] w = (double[])this.weights.clone();
        for (int i = 0; i < w.length; ++i) {
            int n = i;
            w[n] = w[n] + this.deltas[i];
            result += w[i] * w[i];
        }
        NetworkCODEC.arrayToNetwork(w, this.network);
        return result / 2.0;
    }
}

