/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import java.util.Collections;
import java.util.List;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.networks.synapse.neat.NEATLink;
import org.encog.neural.networks.synapse.neat.NEATNeuron;
import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovation;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATLinkGene;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.neural.networks.training.neat.NEATTraining;
import org.encog.neural.pattern.NEATPattern;
import org.encog.persist.annotations.EGAttribute;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genes.BasicGene;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.BasicGenome;
import org.encog.solve.genetic.genome.Chromosome;

public class NEATGenome
extends BasicGenome
implements Cloneable {
    public static final double TWEAK_DISJOINT = 1.0;
    public static final double TWEAK_EXCESS = 1.0;
    public static final double TWEAK_MATCHED = 0.4;
    @EGAttribute
    private int inputCount;
    @EGReference
    private Chromosome linksChromosome;
    @EGAttribute
    private int networkDepth;
    @EGReference
    private Chromosome neuronsChromosome;
    @EGAttribute
    private int outputCount;
    @EGAttribute
    private long speciesID;

    public NEATGenome() {
        super(null);
    }

    public NEATGenome(NEATGenome other) {
        super(other.getGeneticAlgorithm());
        BasicGene newGene;
        BasicGene oldGene;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        this.setGenomeID(other.getGenomeID());
        this.networkDepth = other.networkDepth;
        this.setScore(other.getScore());
        this.setAdjustedScore(other.getAdjustedScore());
        this.setAmountToSpawn(other.getAmountToSpawn());
        this.inputCount = other.inputCount;
        this.outputCount = other.outputCount;
        this.speciesID = other.speciesID;
        for (Gene gene : other.getNeurons().getGenes()) {
            oldGene = (NEATNeuronGene)gene;
            newGene = new NEATNeuronGene(((NEATNeuronGene)oldGene).getNeuronType(), oldGene.getId(), ((NEATNeuronGene)oldGene).getSplitY(), ((NEATNeuronGene)oldGene).getSplitX(), ((NEATNeuronGene)oldGene).isRecurrent(), ((NEATNeuronGene)oldGene).getActivationResponse());
            this.getNeurons().add(newGene);
        }
        for (Gene gene : other.getLinks().getGenes()) {
            oldGene = (NEATLinkGene)gene;
            newGene = new NEATLinkGene(((NEATLinkGene)oldGene).getFromNeuronID(), ((NEATLinkGene)oldGene).getToNeuronID(), oldGene.isEnabled(), oldGene.getInnovationId(), ((NEATLinkGene)oldGene).getWeight(), ((NEATLinkGene)oldGene).isRecurrent());
            this.getLinks().add(newGene);
        }
    }

    public NEATGenome(NEATTraining training, long genomeID, Chromosome neurons, Chromosome links, int inputCount, int outputCount) {
        super(training);
        this.setGenomeID(genomeID);
        this.linksChromosome = links;
        this.neuronsChromosome = neurons;
        this.setAmountToSpawn(0.0);
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
    }

    public NEATGenome(NEATTraining training, long id, int inputCount, int outputCount) {
        super(training);
        int i;
        this.setGenomeID(id);
        this.setAdjustedScore(0.0);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.setAmountToSpawn(0.0);
        this.speciesID = 0L;
        double inputRowSlice = 0.8 / (double)inputCount;
        this.neuronsChromosome = new Chromosome();
        this.linksChromosome = new Chromosome();
        this.getChromosomes().add(this.neuronsChromosome);
        this.getChromosomes().add(this.linksChromosome);
        for (int i2 = 0; i2 < inputCount; ++i2) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Input, i2, 0.0, 0.1 + (double)i2 * inputRowSlice));
        }
        this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Bias, inputCount, 0.0, 0.9));
        double outputRowSlice = 1.0 / (double)(outputCount + 1);
        for (i = 0; i < outputCount; ++i) {
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Output, i + inputCount + 1, 1.0, (double)(i + 1) * outputRowSlice));
        }
        for (i = 0; i < inputCount + 1; ++i) {
            for (int j = 0; j < outputCount; ++j) {
                this.linksChromosome.add(new NEATLinkGene(((NEATNeuronGene)this.neuronsChromosome.get(i)).getId(), ((NEATNeuronGene)this.getNeurons().get(inputCount + j + 1)).getId(), true, inputCount + outputCount + 1 + this.getNumGenes(), RangeRandomizer.randomize(-1.0, 1.0), false));
            }
        }
    }

    void addLink(double mutationRate, double chanceOfLooped, int numTrysToFindLoop, int numTrysToAddLink) {
        if (Math.random() > mutationRate) {
            return;
        }
        int countTrysToFindLoop = numTrysToFindLoop;
        int countTrysToAddLink = numTrysToFindLoop;
        long neuron1ID = -1L;
        long neuron2ID = -1L;
        boolean recurrent = false;
        if (Math.random() < chanceOfLooped) {
            while (countTrysToFindLoop-- > 0) {
                NEATNeuronGene neuronGene = this.chooseRandomNeuron(false);
                if (neuronGene.isRecurrent() || neuronGene.getNeuronType() == NEATNeuronType.Bias || neuronGene.getNeuronType() == NEATNeuronType.Input) continue;
                neuron1ID = neuronGene.getId();
                neuron2ID = neuronGene.getId();
                neuronGene.setRecurrent(true);
                recurrent = true;
                countTrysToFindLoop = 0;
            }
        } else {
            while (countTrysToAddLink-- > 0) {
                NEATNeuronGene neuron1 = this.chooseRandomNeuron(true);
                NEATNeuronGene neuron2 = this.chooseRandomNeuron(false);
                if (this.isDuplicateLink(neuron1ID, neuron2ID) || neuron1.getId() == neuron2.getId() || neuron2.getNeuronType() == NEATNeuronType.Bias) continue;
                neuron1ID = neuron1.getId();
                neuron2ID = neuron2.getId();
                break;
            }
        }
        if (neuron1ID < 0L || neuron2ID < 0L) {
            return;
        }
        NEATInnovation innovation = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(neuron1ID, neuron1ID, NEATInnovationType.NewLink);
        NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.get(this.getElementPos(neuron1ID));
        if (neuronGene.getSplitY() > neuronGene.getSplitY()) {
            recurrent = true;
        }
        if (innovation == null) {
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(neuron1ID, neuron2ID, NEATInnovationType.NewLink);
            long id2 = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            NEATLinkGene linkGene = new NEATLinkGene(neuron1ID, neuron2ID, true, id2, RangeRandomizer.randomize(-1.0, 1.0), recurrent);
            this.linksChromosome.add(linkGene);
        } else {
            NEATLinkGene linkGene = new NEATLinkGene(neuron1ID, neuron2ID, true, innovation.getInnovationID(), RangeRandomizer.randomize(-1.0, 1.0), recurrent);
            this.linksChromosome.add(linkGene);
        }
    }

    void addNeuron(double mutationRate, int numTrysToFindOldLink) {
        long newNeuronID;
        long neuronID;
        if (Math.random() > mutationRate) {
            return;
        }
        int countTrysToFindOldLink = numTrysToFindOldLink;
        BasicGene splitLink = null;
        int sizeBias = this.inputCount + this.outputCount + 10;
        int upperLimit = this.linksChromosome.size() < sizeBias ? this.getNumGenes() - 1 - (int)Math.sqrt(this.getNumGenes()) : this.getNumGenes() - 1;
        while (countTrysToFindOldLink-- > 0) {
            int i = RangeRandomizer.randomInt(0, upperLimit);
            NEATLinkGene link = (NEATLinkGene)this.linksChromosome.get(i);
            long fromNeuron = link.getFromNeuronID();
            if (!link.isEnabled() || link.isRecurrent() || ((NEATNeuronGene)this.getNeurons().get(this.getElementPos(fromNeuron))).getNeuronType() == NEATNeuronType.Bias) continue;
            splitLink = link;
            break;
        }
        if (splitLink == null) {
            return;
        }
        splitLink.setEnabled(false);
        double originalWeight = ((NEATLinkGene)splitLink).getWeight();
        long from = ((NEATLinkGene)splitLink).getFromNeuronID();
        long to = ((NEATLinkGene)splitLink).getToNeuronID();
        NEATNeuronGene fromGene = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(from));
        NEATNeuronGene toGene = (NEATNeuronGene)this.getNeurons().get(this.getElementPos(to));
        double newDepth = (fromGene.getSplitY() + toGene.getSplitY()) / 2.0;
        double newWidth = (fromGene.getSplitX() + toGene.getSplitX()) / 2.0;
        NEATInnovation innovation = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(from, to, NEATInnovationType.NewNeuron);
        if (innovation != null && this.alreadyHaveThisNeuronID(neuronID = innovation.getNeuronID())) {
            innovation = null;
        }
        if (innovation == null) {
            newNeuronID = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(from, to, NEATInnovationType.NewNeuron, NEATNeuronType.Hidden, newWidth, newDepth);
            this.neuronsChromosome.add(new NEATNeuronGene(NEATNeuronType.Hidden, newNeuronID, newDepth, newWidth));
            long link1ID = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(from, newNeuronID, NEATInnovationType.NewLink);
            NEATLinkGene link1 = new NEATLinkGene(from, newNeuronID, true, link1ID, 1.0, false);
            this.linksChromosome.add(link1);
            long link2ID = ((NEATTraining)this.getGeneticAlgorithm()).getPopulation().assignInnovationID();
            ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().createNewInnovation(newNeuronID, to, NEATInnovationType.NewLink);
            NEATLinkGene link2 = new NEATLinkGene(newNeuronID, to, true, link2ID, originalWeight, false);
            this.linksChromosome.add(link2);
        } else {
            newNeuronID = innovation.getNeuronID();
            NEATInnovation innovationLink1 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(from, newNeuronID, NEATInnovationType.NewLink);
            NEATInnovation innovationLink2 = ((NEATTraining)this.getGeneticAlgorithm()).getInnovations().checkInnovation(newNeuronID, to, NEATInnovationType.NewLink);
            if (innovationLink1 == null || innovationLink2 == null) {
                throw new NeuralNetworkError("NEAT Error");
            }
            NEATLinkGene link1 = new NEATLinkGene(from, newNeuronID, true, innovationLink1.getInnovationID(), 1.0, false);
            NEATLinkGene link2 = new NEATLinkGene(newNeuronID, to, true, innovationLink2.getInnovationID(), originalWeight, false);
            this.linksChromosome.add(link1);
            this.linksChromosome.add(link2);
            NEATNeuronGene newNeuron = new NEATNeuronGene(NEATNeuronType.Hidden, newNeuronID, newDepth, newWidth);
            this.neuronsChromosome.add(newNeuron);
        }
    }

    public boolean alreadyHaveThisNeuronID(long id) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            if (neuronGene.getId() != id) continue;
            return true;
        }
        return false;
    }

    private NEATNeuronGene chooseRandomNeuron(boolean includeInput) {
        int start = includeInput ? 0 : this.inputCount + 1;
        int neuronPos = RangeRandomizer.randomInt(start, this.getNeurons().size() - 1);
        NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.get(neuronPos);
        return neuronGene;
    }

    @Override
    public void decode() {
        NEATPattern pattern = new NEATPattern();
        List<NEATNeuron> neurons = pattern.getNeurons();
        for (Gene gene : this.getNeurons().getGenes()) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            NEATNeuron neuron = new NEATNeuron(neuronGene.getNeuronType(), neuronGene.getId(), neuronGene.getSplitY(), neuronGene.getSplitX(), neuronGene.getActivationResponse());
            neurons.add(neuron);
        }
        for (Gene gene : this.getLinks().getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (!linkGene.isEnabled()) continue;
            int element = this.getElementPos(linkGene.getFromNeuronID());
            NEATNeuron fromNeuron = neurons.get(element);
            element = this.getElementPos(linkGene.getToNeuronID());
            NEATNeuron toNeuron = neurons.get(element);
            NEATLink link = new NEATLink(linkGene.getWeight(), fromNeuron, toNeuron, linkGene.isRecurrent());
            fromNeuron.getOutputboundLinks().add(link);
            toNeuron.getInboundLinks().add(link);
        }
        pattern.setNEATActivationFunction(((NEATTraining)this.getGeneticAlgorithm()).getNeatActivationFunction());
        pattern.setActivationFunction(((NEATTraining)this.getGeneticAlgorithm()).getOutputActivationFunction());
        pattern.setInputNeurons(this.inputCount);
        pattern.setOutputNeurons(this.outputCount);
        pattern.setSnapshot(((NEATTraining)this.getGeneticAlgorithm()).isSnapshot());
        this.setOrganism(pattern.generate());
    }

    @Override
    public void encode() {
    }

    public double getCompatibilityScore(NEATGenome genome) {
        double numDisjoint = 0.0;
        double numExcess = 0.0;
        double numMatched = 0.0;
        double weightDifference = 0.0;
        int g1 = 0;
        int g2 = 0;
        while (g1 < this.linksChromosome.size() - 1 || g2 < this.linksChromosome.size() - 1) {
            long id2;
            if (g1 == this.linksChromosome.size() - 1) {
                ++g2;
                numExcess += 1.0;
                continue;
            }
            if (g2 == genome.getLinks().size() - 1) {
                ++g1;
                numExcess += 1.0;
                continue;
            }
            long id1 = ((NEATLinkGene)this.linksChromosome.get(g1)).getInnovationId();
            if (id1 == (id2 = ((NEATLinkGene)genome.getLinks().get(g2)).getInnovationId())) {
                numMatched += 1.0;
                weightDifference += Math.abs(((NEATLinkGene)this.linksChromosome.get(++g1)).getWeight() - ((NEATLinkGene)genome.getLinks().get(++g2)).getWeight());
            }
            if (id1 < id2) {
                numDisjoint += 1.0;
                ++g1;
            }
            if (id1 <= id2) continue;
            numDisjoint += 1.0;
            ++g2;
        }
        int longest = genome.getNumGenes();
        if (this.getNumGenes() > longest) {
            longest = this.getNumGenes();
        }
        double score = 1.0 * numExcess / (double)longest + 1.0 * numDisjoint / (double)longest + 0.4 * weightDifference / numMatched;
        return score;
    }

    private int getElementPos(long neuronID) {
        for (int i = 0; i < this.getNeurons().size(); ++i) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)this.neuronsChromosome.getGene(i);
            if (neuronGene.getId() != neuronID) continue;
            return i;
        }
        return -1;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public Chromosome getLinks() {
        return this.linksChromosome;
    }

    public int getNetworkDepth() {
        return this.networkDepth;
    }

    public Chromosome getNeurons() {
        return this.neuronsChromosome;
    }

    public int getNumGenes() {
        return this.linksChromosome.size();
    }

    public int getOutputCount() {
        return this.outputCount;
    }

    public long getSpeciesID() {
        return this.speciesID;
    }

    public double getSplitY(int nd) {
        return ((NEATNeuronGene)this.neuronsChromosome.get(nd)).getSplitY();
    }

    public boolean isDuplicateLink(long fromNeuronID, long toNeuronID) {
        for (Gene gene : this.getLinks().getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (linkGene.getFromNeuronID() != fromNeuronID || linkGene.getToNeuronID() != toNeuronID) continue;
            return true;
        }
        return false;
    }

    public void mutateActivationResponse(double mutateRate, double maxPertubation) {
        for (Gene gene : this.neuronsChromosome.getGenes()) {
            if (!(Math.random() < mutateRate)) continue;
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            neuronGene.setActivationResponse(neuronGene.getActivationResponse() + RangeRandomizer.randomize(-1.0, 1.0) * maxPertubation);
        }
    }

    public void mutateWeights(double mutateRate, double probNewMutate, double maxPertubation) {
        for (Gene gene : this.linksChromosome.getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            if (!(Math.random() < mutateRate)) continue;
            if (Math.random() < probNewMutate) {
                linkGene.setWeight(RangeRandomizer.randomize(-1.0, 1.0));
                continue;
            }
            linkGene.setWeight(linkGene.getWeight() + RangeRandomizer.randomize(-1.0, 1.0) * maxPertubation);
        }
    }

    public void setNetworkDepth(int networkDepth) {
        this.networkDepth = networkDepth;
    }

    public void setSpeciesID(long species) {
        this.speciesID = species;
    }

    public void sortGenes() {
        Collections.sort(this.linksChromosome.getGenes());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NEATGenome:");
        result.append(this.getGenomeID());
        result.append(",fitness=");
        result.append(this.getScore());
        result.append(")");
        return result.toString();
    }
}

