/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.persist.annotations.EGAttribute;
import org.encog.solve.genetic.innovation.BasicInnovation;

public class NEATInnovation
extends BasicInnovation {
    @EGAttribute
    private long fromNeuronID;
    @EGAttribute
    private NEATInnovationType innovationType;
    @EGAttribute
    private long neuronID;
    @EGAttribute
    private NEATNeuronType neuronType;
    @EGAttribute
    private double splitX;
    @EGAttribute
    private double splitY;
    @EGAttribute
    private long toNeuronID;

    public NEATInnovation() {
    }

    public NEATInnovation(long fromNeuronID, long toNeuronID, NEATInnovationType innovationType, long innovationID) {
        this.fromNeuronID = fromNeuronID;
        this.toNeuronID = toNeuronID;
        this.innovationType = innovationType;
        this.setInnovationID(innovationID);
        this.neuronID = -1L;
        this.splitX = 0.0;
        this.splitY = 0.0;
        this.neuronType = NEATNeuronType.None;
    }

    public NEATInnovation(long fromNeuronID, long toNeuronID, NEATInnovationType innovationType, long innovationID, NEATNeuronType neuronType, double x, double y) {
        this.fromNeuronID = fromNeuronID;
        this.toNeuronID = toNeuronID;
        this.innovationType = innovationType;
        this.setInnovationID(innovationID);
        this.neuronType = neuronType;
        this.splitX = x;
        this.splitY = y;
        this.neuronID = 0L;
    }

    public NEATInnovation(NEATNeuronGene neuronGene, long innovationID, long neuronID) {
        this.neuronID = neuronID;
        this.setInnovationID(innovationID);
        this.splitX = neuronGene.getSplitX();
        this.splitY = neuronGene.getSplitY();
        this.neuronType = neuronGene.getNeuronType();
        this.innovationType = NEATInnovationType.NewNeuron;
        this.fromNeuronID = -1L;
        this.toNeuronID = -1L;
    }

    public long getFromNeuronID() {
        return this.fromNeuronID;
    }

    public NEATInnovationType getInnovationType() {
        return this.innovationType;
    }

    public long getNeuronID() {
        return this.neuronID;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public long getToNeuronID() {
        return this.toNeuronID;
    }

    public void setNeuronID(long neuronID) {
        this.neuronID = neuronID;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[NeatInnovation:type=");
        switch (this.innovationType) {
            case NewLink: {
                result.append("link");
                break;
            }
            case NewNeuron: {
                result.append("neuron");
            }
        }
        result.append(",from=");
        result.append(this.fromNeuronID);
        result.append(",to=");
        result.append(this.toNeuronID);
        result.append(",splitX=");
        result.append(this.splitX);
        result.append(",splitY=");
        result.append(this.splitY);
        result.append("]");
        return result.toString();
    }
}

