/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.neural.networks.training.neat.NEATInnovation;
import org.encog.neural.networks.training.neat.NEATInnovationType;
import org.encog.neural.networks.training.neat.NEATLinkGene;
import org.encog.neural.networks.training.neat.NEATNeuronGene;
import org.encog.persist.annotations.EGReference;
import org.encog.solve.genetic.genes.Gene;
import org.encog.solve.genetic.genome.Chromosome;
import org.encog.solve.genetic.innovation.BasicInnovationList;
import org.encog.solve.genetic.innovation.Innovation;
import org.encog.solve.genetic.population.Population;

public class NEATInnovationList
extends BasicInnovationList {
    private long nextNeuronID = 0L;
    @EGReference
    private Population population;

    public NEATInnovationList() {
    }

    public NEATInnovationList(Population population, Chromosome links, Chromosome neurons) {
        NEATInnovation innovation;
        this.population = population;
        for (Gene gene : neurons.getGenes()) {
            NEATNeuronGene neuronGene = (NEATNeuronGene)gene;
            innovation = new NEATInnovation(neuronGene, population.assignInnovationID(), this.assignNeuronID());
            this.add(innovation);
        }
        for (Gene gene : links.getGenes()) {
            NEATLinkGene linkGene = (NEATLinkGene)gene;
            innovation = new NEATInnovation(linkGene.getFromNeuronID(), linkGene.getToNeuronID(), NEATInnovationType.NewLink, this.population.assignInnovationID());
            this.add(innovation);
        }
    }

    private long assignNeuronID() {
        return this.nextNeuronID++;
    }

    public NEATInnovation checkInnovation(long in, long out, NEATInnovationType type) {
        for (Innovation i : this.getInnovations()) {
            NEATInnovation innovation = (NEATInnovation)i;
            if (innovation.getFromNeuronID() != in || innovation.getToNeuronID() != out || innovation.getInnovationType() != type) continue;
            return innovation;
        }
        return null;
    }

    public NEATNeuronGene createNeuronFromID(long neuronID) {
        NEATNeuronGene result = new NEATNeuronGene(NEATNeuronType.Hidden, 0L, 0.0, 0.0);
        for (Innovation i : this.getInnovations()) {
            NEATInnovation innovation = (NEATInnovation)i;
            if (innovation.getNeuronID() != neuronID) continue;
            result.setNeuronType(innovation.getNeuronType());
            result.setId(innovation.getNeuronID());
            result.setSplitY(innovation.getSplitY());
            result.setSplitX(innovation.getSplitX());
            return result;
        }
        return result;
    }

    public void createNewInnovation(long in, long out, NEATInnovationType type) {
        NEATInnovation newInnovation = new NEATInnovation(in, out, type, this.population.assignInnovationID());
        if (type == NEATInnovationType.NewNeuron) {
            newInnovation.setNeuronID(this.assignNeuronID());
        }
        this.add(newInnovation);
    }

    public long createNewInnovation(long from, long to, NEATInnovationType innovationType, NEATNeuronType neuronType, double x, double y) {
        NEATInnovation newInnovation = new NEATInnovation(from, to, innovationType, this.population.assignInnovationID(), neuronType, x, y);
        if (innovationType == NEATInnovationType.NewNeuron) {
            newInnovation.setNeuronID(this.assignNeuronID());
        }
        this.add(newInnovation);
        return this.nextNeuronID - 1L;
    }
}

