/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.neat;

import org.encog.neural.networks.synapse.neat.NEATNeuronType;
import org.encog.persist.annotations.EGAttribute;
import org.encog.solve.genetic.genes.BasicGene;
import org.encog.solve.genetic.genes.Gene;

public class NEATNeuronGene
extends BasicGene {
    @EGAttribute
    private double activationResponse;
    @EGAttribute
    private NEATNeuronType neuronType;
    @EGAttribute
    private boolean recurrent;
    @EGAttribute
    private double splitX;
    @EGAttribute
    private double splitY;

    public NEATNeuronGene() {
    }

    public NEATNeuronGene(NEATNeuronType type, long id, double splitY, double splitX) {
        this(type, id, splitY, splitX, false, 1.0);
    }

    public NEATNeuronGene(NEATNeuronType type, long id, double splitY, double splitX, boolean recurrent, double act) {
        this.neuronType = type;
        this.setId(id);
        this.splitX = splitX;
        this.splitY = splitY;
        this.recurrent = recurrent;
        this.activationResponse = act;
    }

    @Override
    public void copy(Gene gene) {
        NEATNeuronGene other = (NEATNeuronGene)gene;
        this.activationResponse = other.activationResponse;
        this.setId(other.getId());
        this.neuronType = other.neuronType;
        this.recurrent = other.recurrent;
        this.splitX = other.splitX;
        this.splitY = other.splitY;
    }

    public double getActivationResponse() {
        return this.activationResponse;
    }

    public NEATNeuronType getNeuronType() {
        return this.neuronType;
    }

    public double getSplitX() {
        return this.splitX;
    }

    public double getSplitY() {
        return this.splitY;
    }

    public boolean isRecurrent() {
        return this.recurrent;
    }

    public void setActivationResponse(double activationResponse) {
        this.activationResponse = activationResponse;
    }

    public void setNeuronType(NEATNeuronType neuronType) {
        this.neuronType = neuronType;
    }

    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    public void setSplitX(double splitX) {
        this.splitX = splitX;
    }

    public void setSplitY(double splitY) {
        this.splitY = splitY;
    }
}

