/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.manhattan;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.network.train.prop.TrainFlatNetworkBackPropagation;
import org.encog.engine.network.train.prop.TrainFlatNetworkManhattan;
import org.encog.engine.network.train.prop.TrainFlatNetworkOpenCL;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.LearningRate;
import org.encog.neural.networks.training.propagation.Propagation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManhattanPropagation
extends Propagation
implements LearningRate {
    static final double DEFAULT_ZERO_TOLERANCE = 0.001;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ManhattanPropagation(BasicNetwork network, NeuralDataSet training, double learnRate) {
        this(network, training, null, learnRate);
    }

    public ManhattanPropagation(BasicNetwork network, NeuralDataSet training, OpenCLTrainingProfile profile, double learnRate) {
        super(network, training);
        if (profile == null) {
            this.setFlatTraining(new TrainFlatNetworkManhattan(network.getStructure().getFlat(), this.getTraining(), learnRate));
        } else {
            TrainFlatNetworkOpenCL rpropFlat = new TrainFlatNetworkOpenCL(network.getStructure().getFlat(), this.getTraining(), profile);
            rpropFlat.learnManhattan(learnRate);
            this.setFlatTraining(rpropFlat);
        }
    }

    @Override
    public double getLearningRate() {
        return ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).getLearningRate();
    }

    @Override
    public void setLearningRate(double rate) {
        ((TrainFlatNetworkBackPropagation)this.getFlatTraining()).setLearningRate(rate);
    }
}

