/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.resilient;

import org.encog.engine.network.train.prop.OpenCLTrainingProfile;
import org.encog.engine.network.train.prop.TrainFlatNetworkOpenCL;
import org.encog.engine.network.train.prop.TrainFlatNetworkResilient;
import org.encog.engine.util.EngineArray;
import org.encog.neural.data.NeuralDataSet;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.TrainingError;
import org.encog.neural.networks.training.propagation.Propagation;
import org.encog.neural.networks.training.propagation.TrainingContinuation;

public class ResilientPropagation
extends Propagation {
    public static final String LAST_GRADIENTS = "LAST_GRADIENTS";
    public static final String UPDATE_VALUES = "UPDATE_VALUES";

    public ResilientPropagation(BasicNetwork network, NeuralDataSet training) {
        this(network, training, null, 0.1, 50.0);
    }

    public ResilientPropagation(BasicNetwork network, NeuralDataSet training, OpenCLTrainingProfile profile) {
        this(network, training, profile, 0.1, 50.0);
    }

    public ResilientPropagation(BasicNetwork network, NeuralDataSet training, OpenCLTrainingProfile profile, double initialUpdate, double maxStep) {
        super(network, training);
        if (profile == null) {
            TrainFlatNetworkResilient rpropFlat = new TrainFlatNetworkResilient(network.getStructure().getFlat(), this.getTraining());
            this.setFlatTraining(rpropFlat);
        } else {
            TrainFlatNetworkOpenCL rpropFlat = new TrainFlatNetworkOpenCL(network.getStructure().getFlat(), this.getTraining(), profile);
            rpropFlat.learnRPROP(initialUpdate, maxStep);
            this.setFlatTraining(rpropFlat);
        }
    }

    @Override
    public boolean canContinue() {
        return true;
    }

    @Override
    public boolean isValidResume(TrainingContinuation state) {
        if (!state.getContents().containsKey(LAST_GRADIENTS) || !state.getContents().containsKey(UPDATE_VALUES)) {
            return false;
        }
        double[] d = (double[])state.get(LAST_GRADIENTS);
        return d.length == this.getNetwork().getStructure().calculateSize();
    }

    @Override
    public TrainingContinuation pause() {
        TrainingContinuation result = new TrainingContinuation();
        if (this.getFlatTraining() instanceof TrainFlatNetworkResilient) {
            result.set(LAST_GRADIENTS, ((TrainFlatNetworkResilient)this.getFlatTraining()).getLastGradient());
            result.set(UPDATE_VALUES, ((TrainFlatNetworkResilient)this.getFlatTraining()).getUpdateValues());
        } else {
            result.set(LAST_GRADIENTS, ((TrainFlatNetworkOpenCL)this.getFlatTraining()).getLastGradient());
            result.set(UPDATE_VALUES, ((TrainFlatNetworkOpenCL)this.getFlatTraining()).getUpdateValues());
        }
        return result;
    }

    @Override
    public void resume(TrainingContinuation state) {
        if (!this.isValidResume(state)) {
            throw new TrainingError("Invalid training resume data length");
        }
        double[] lastGradient = (double[])state.get(LAST_GRADIENTS);
        double[] updateValues = (double[])state.get(UPDATE_VALUES);
        if (this.getFlatTraining() instanceof TrainFlatNetworkResilient) {
            EngineArray.arrayCopy(lastGradient, ((TrainFlatNetworkResilient)this.getFlatTraining()).getLastGradient());
            EngineArray.arrayCopy(updateValues, ((TrainFlatNetworkResilient)this.getFlatTraining()).getUpdateValues());
        } else if (this.getFlatTraining() instanceof TrainFlatNetworkOpenCL) {
            EngineArray.arrayCopy(lastGradient, ((TrainFlatNetworkOpenCL)this.getFlatTraining()).getLastGradient());
            EngineArray.arrayCopy(updateValues, ((TrainFlatNetworkOpenCL)this.getFlatTraining()).getUpdateValues());
        }
    }
}

