/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADALINEPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void addHiddenLayer(int count) {
        String str = "An ADALINE network has no hidden layers.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("An ADALINE network has no hidden layers.");
        }
        throw new PatternError("An ADALINE network has no hidden layers.");
    }

    @Override
    public void clear() {
        this.inputNeurons = 0;
        this.outputNeurons = 0;
    }

    @Override
    public BasicNetwork generate() {
        BasicNetwork network = new BasicNetwork();
        int y = 50;
        BasicLayer inputLayer = new BasicLayer(new ActivationLinear(), false, this.inputNeurons);
        BasicLayer outputLayer = new BasicLayer(new ActivationLinear(), true, this.outputNeurons);
        network.addLayer(inputLayer);
        network.addLayer(outputLayer);
        network.getStructure().finalizeStructure();
        new RangeRandomizer(-0.5, 0.5).randomize(network);
        inputLayer.setX(50);
        inputLayer.setY(y);
        outputLayer.setX(50);
        outputLayer.setY(y += 150);
        return network;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        String str = "A ADALINE network can't specify a custom activation function.";
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A ADALINE network can't specify a custom activation function.");
        }
        throw new PatternError("A ADALINE network can't specify a custom activation function.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }
}

